/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.util.StandardFormats;

public class SliderText
extends HorizontalGroup {
    private Slider slider;
    private Label value;
    private StandardFormats format = StandardFormats.FLOAT_COUNT;

    public SliderText(Skin skin, String sliderStyle, String labelStyle) {
        this.space(5.0f);
        this.slider = new Slider(0.0f, 1.0f, 0.1f, false, skin);
        this.value = new Label("", skin, labelStyle);
        this.slider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SliderText.this.value.setText(SliderText.this.format.format(Float.valueOf(SliderText.this.slider.getValue())));
            }
        });
        this.setValue(0.0f);
        this.addActor(this.slider);
        this.addActor(this.value);
    }

    public SliderText(Skin skin, float min, float max, float step) {
        this.space(5.0f);
        this.slider = new Slider(min, max, step, false, skin);
        this.value = new Label("", skin, "default-no-bg");
        this.slider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SliderText.this.value.setText(SliderText.this.format.format(Float.valueOf(SliderText.this.slider.getValue())));
            }
        });
        this.setValue(0.0f);
        this.addActor(this.slider);
        this.addActor(this.value);
    }

    public void setValue(float value) {
        this.slider.setValue(value);
        this.value.setText(this.format.format(Float.valueOf(value)));
    }

    public float getValue() {
        return this.slider.getValue();
    }
}

