/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.io.files.FileUtils;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import java.io.IOException;
import java.net.URISyntaxException;

public class SocialButtons
extends SimplePanel {
    boolean vertical = false;

    public SocialButtons(ComponentFactory componentFactory) {
        super(componentFactory, "buttons", null);
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public void addButton(String tooltip, CustomAction action, AstraXButton button) {
        this.addValue(button);
        if (this.vertical) {
            this.row();
        }
        button.setCanCheck(false);
        button.setButtonAction(action);
        if (tooltip != null) {
            button.addListener(this.componentFactory.getToolTip(tooltip));
        }
    }

    public void addButton(CustomAction action, AstraXButton button) {
        this.addButton(null, action, button);
    }

    public void addButton(String tooltip, final String link, AstraXButton button) {
        CustomAction openLinkAction = CustomAction.get(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.openInWebBrowser(link);
                }
                catch (IOException | URISyntaxException e) {
                    AstraXApp.astraX.showErrorAlert("Could not open browser!");
                    e.printStackTrace();
                }
            }
        });
        this.addButton(tooltip, openLinkAction, button);
    }

    public void addButton(String link, AstraXButton button) {
        this.addButton(null, link, button);
    }
}

