/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.Objects;

public class StackController {
    private boolean isCyclic = true;
    private int currentIndex = 0;
    private Actor currentContent = null;
    private Stack contentStack;
    protected ActionProducer showActionProducer;
    protected ActionProducer hideActionProducer;

    public StackController(Stack stack) {
        this.contentStack = stack;
        this.showActionProducer = new ActionProducer(){

            @Override
            public Action createAction() {
                return Tweening.getStackControllerFadeIn();
            }
        };
        this.hideActionProducer = new ActionProducer(){

            @Override
            public Action createAction() {
                return Tweening.getStackControllerFadeOut();
            }
        };
        if (this.contentStack.getChildren().size > 0) {
            for (Actor actor : this.contentStack.getChildren()) {
                actor.setVisible(false);
            }
            this.show((Actor)this.contentStack.getChildren().get(0));
        }
    }

    public void setShowActionProducer(ActionProducer showActionProducer) {
        this.showActionProducer = showActionProducer;
    }

    public void setHideActionProducer(ActionProducer hideActionProducer) {
        this.hideActionProducer = hideActionProducer;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.isCyclic = cyclic;
    }

    public Actor getCurrentContent() {
        return this.currentContent;
    }

    public boolean isShowingFirst() {
        return this.currentIndex == 0;
    }

    public boolean isShowingLast() {
        return this.currentIndex == this.contentStack.getChildren().size - 1;
    }

    public void next() {
        ++this.currentIndex;
        if (this.currentIndex >= this.contentStack.getChildren().size) {
            this.currentIndex = this.isCyclic ? 0 : this.contentStack.getChildren().size - 1;
        }
        this.show(this.currentIndex);
    }

    public void previous() {
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = this.isCyclic ? this.contentStack.getChildren().size - 1 : 0;
        }
        this.show(this.currentIndex);
    }

    public void show(Class contentType) {
        int i2 = 0;
        for (Actor actor : this.contentStack.getChildren()) {
            if (Objects.equals(actor.getClass(), contentType)) {
                this.currentIndex = i2;
                this.show((Actor)this.contentStack.getChildren().get(i2));
                return;
            }
            ++i2;
        }
    }

    public void show(int index) {
        int i2 = 0;
        for (Actor actor : this.contentStack.getChildren()) {
            if (i2 == index) {
                this.currentIndex = i2;
                this.show(actor);
                return;
            }
            ++i2;
        }
    }

    public void show(Actor content) {
        if (Objects.equals(this.currentContent, content)) {
            return;
        }
        if (this.currentContent != null) {
            if (this.contentStack.isVisible() && !this.currentContent.hasActions()) {
                this.currentContent.addAction(this.hideActionProducer.createAction());
            } else {
                this.currentContent.setVisible(false);
            }
            this.currentContent = null;
        }
        if (content != null && !content.hasActions()) {
            if (this.contentStack.isVisible()) {
                content.addAction(this.showActionProducer.createAction());
            } else {
                content.setVisible(true);
            }
            this.currentContent = content;
        }
    }

    public void hide() {
        if (this.contentStack.isVisible()) {
            this.currentContent.addAction(this.hideActionProducer.createAction());
        }
    }

    public static interface ActionProducer {
        public Action createAction();
    }
}

