/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.commons.ButtonClickListener;
import com.neutronio.astrax.ui.commons.ScrollContentSettings;
import com.neutronio.astrax.ui.commons.ScrollPaneGroup;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class TextButtonTabs<T extends Button>
extends Table {
    private static Logger logger = Logger.getLogger(TextButtonTabs.class.getCanonicalName());
    private List<T> textButtonList = new ArrayList<T>();
    private TextButtonTabModel tabTextModel = new TextButtonTabModel();
    private ButtonSettings buttonSettings = new ButtonSettings();
    private ScrollContentSettings scrollContentSettings = new ScrollContentSettings();
    private Table content;
    private ScrollPaneGroup textButtonScrollPane;
    private ScrollPaneGroup textScrollPane;
    private TextArea textArea;
    private ChangeListener tabChangeListener;
    private ButtonClickListener buttonClickListener;

    public TextButtonTabs(Skin skin) {
        super(skin);
        this.content = new Table(skin);
        this.textArea = new TextArea("", skin);
        this.textArea.setDisabled(true);
        this.tabChangeListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (actor instanceof Button) {
                    Button button = (Button)actor;
                    String categoryName = (String)button.getUserObject();
                    TextButtonTabs.this.selectContent(categoryName);
                    TextButtonTabs.this.updateButtonCheckedStates(button);
                }
                event.stop();
            }
        };
    }

    public List<T> getTextButtonList() {
        return this.textButtonList;
    }

    public ButtonSettings getButtonSettings() {
        return this.buttonSettings;
    }

    public void setButtonSettings(ButtonSettings buttonSettings) {
        this.buttonSettings = buttonSettings;
    }

    public ScrollContentSettings getContentTabSettings() {
        return this.scrollContentSettings;
    }

    public void setContentTabSettings(ScrollContentSettings scrollContentSettings) {
        this.scrollContentSettings = scrollContentSettings;
    }

    private void updateButtonCheckedStates(Button clickedButton) {
        for (Button otherButtons : this.textButtonList) {
            otherButtons.setChecked(Objects.equals(otherButtons, clickedButton));
        }
    }

    private void selectContent(String categoryName) {
        String displayText = (String)this.tabTextModel.entries.get(categoryName);
        this.textArea.setText(displayText != null ? displayText : "");
    }

    public void construct() {
        this.content.clear();
        this.clear();
        this.updateFromModel();
        this.content.add(this.textButtonScrollPane.container).padRight(10.0f).fill();
        this.content.add(this.textScrollPane.container).minSize(this.scrollContentSettings.minContainerWidth, this.scrollContentSettings.minContainerHeight).fill();
        this.add(this.content).expand().top();
    }

    public void updateFromModel() {
        for (Button button : this.textButtonList) {
            button.removeListener(this.buttonClickListener);
        }
        this.textButtonList.clear();
        this.textButtonScrollPane.scrollContent.clear();
        if (this.tabTextModel != null) {
            for (String categoryName : this.tabTextModel.entries.keySet()) {
                Button button = this.getButton(categoryName, this.buttonSettings);
                button.setProgrammaticChangeEvents(false);
                button.addListener(this.tabChangeListener);
                button.setUserObject(categoryName);
                if (this.buttonClickListener != null) {
                    button.addListener(this.buttonClickListener);
                }
                this.textButtonList.add(button);
                this.textButtonScrollPane.scrollContent.add(button).minSize(this.buttonSettings.minButtonWidth, this.buttonSettings.minButtonHeight).pad(5.0f).fill().row();
            }
        }
        this.textArea.setText("");
    }

    private Button getButton(String title, ButtonSettings buttonSettings) {
        Button.ButtonStyle buttonStyle = this.getSkin().get(buttonSettings.styleName, buttonSettings.styleClass);
        if (buttonStyle instanceof ImageTextButton.ImageTextButtonStyle) {
            return new ImageTextButton(title, (ImageTextButton.ImageTextButtonStyle)buttonStyle);
        }
        if (buttonStyle instanceof TextButton.TextButtonStyle) {
            TextButton button = new TextButton(title, (TextButton.TextButtonStyle)buttonStyle);
            CharSequence text = button.getText();
            return button;
        }
        if (buttonStyle instanceof Button.ButtonStyle) {
            return new Button(buttonStyle);
        }
        return null;
    }

    public TextButtonTabModel getTabTextModel() {
        return this.tabTextModel;
    }

    public void setTabTextModel(TextButtonTabModel tabTextModel) {
        this.tabTextModel = tabTextModel;
        this.updateFromModel();
    }

    public void setTextButtonScrollPane(ScrollPaneGroup textButtonScrollPane) {
        this.textButtonScrollPane = textButtonScrollPane;
        this.textButtonScrollPane.scrollPane.setFadeScrollBars(false);
    }

    public void setTextScrollPane(ScrollPaneGroup textScrollPane) {
        this.textScrollPane = textScrollPane;
        this.textScrollPane.scrollContent.add(this.textArea).pad(10.0f).minSize(this.scrollContentSettings.minScrollableContentWidth, this.scrollContentSettings.minScrollableContentHeight);
        this.textScrollPane.scrollContent.pack();
        this.textScrollPane.scrollPane.pack();
        this.textScrollPane.container.pack();
    }

    public ButtonClickListener getButtonClickListener() {
        return this.buttonClickListener;
    }

    public void setButtonClickListener(ButtonClickListener buttonClickListener) {
        this.buttonClickListener = buttonClickListener;
    }

    public static class TextButtonTabModel {
        private Map<String, String> entries = new LinkedHashMap<String, String>();

        public String getEntry(String categoryName) {
            return this.entries.get(categoryName);
        }

        public void addEntry(String categoryName, String longText) {
            this.entries.put(categoryName, longText);
        }

        public void clear() {
            this.entries.clear();
        }
    }

    public static class ButtonSettings {
        public Class<? extends Button.ButtonStyle> styleClass = TextButton.TextButtonStyle.class;
        public String styleName = "default";
        public int minButtonWidth = 150;
        public int minButtonHeight = 20;

        public ButtonSettings() {
        }

        public ButtonSettings(String styleName) {
            this.styleName = styleName;
        }
    }
}

