/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.widgets.Zoomable;
import com.neutronio.astrax.util.StandardFormats;

public class ZoomButtons
extends Table {
    private AstraXButton zoomInButton;
    private AstraXButton zoomOutButton;
    private AstraXTextButton resetZoomButton;
    private Zoomable zoomable;

    public ZoomButtons(ComponentFactory factory) {
        Skin skin = factory.getSkin();
        this.zoomInButton = new AstraXButton(factory, "icon_inline_zoom_in", "primary");
        this.zoomInButton.setSize(32.0f, 32.0f);
        this.zoomInButton.addListener(factory.getButtonSoundListener("zoom:in"));
        this.zoomInButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                ZoomButtons.this.getZoomable().zoomIn(2.0f);
                event.stop();
            }
        });
        this.zoomInButton.addListener(new TextTooltip(factory.translate("tooltip_zoom_in"), skin));
        this.zoomInButton.setDisabled(false);
        this.zoomInButton.setCanCheck(false);
        this.resetZoomButton = new AstraXTextButton(factory, "inventory-multiplier");
        this.resetZoomButton.setCanCheck(false);
        this.resetZoomButton.setSquishable(false);
        this.resetZoomButton.addListener(factory.getButtonSoundListener("zoom:reset"));
        this.resetZoomButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ZoomButtons.this.getZoomable().resetZoom();
                event.stop();
            }
        });
        this.resetZoomButton.addListener(new TextTooltip(factory.translate("tooltip_zoom_reset"), skin));
        this.resetZoomButton.setDisabled(false);
        this.resetZoomButton.setStyle(this.resetZoomButton.getStyle().copy());
        this.resetZoomButton.getStyle().width = 60;
        this.resetZoomButton.getStyle().height = 24;
        this.zoomOutButton = new AstraXButton(factory, "icon_inline_zoom_out", "primary");
        this.zoomOutButton.setSize(32.0f, 32.0f);
        this.zoomOutButton.addListener(factory.getButtonSoundListener("zoom:out"));
        this.zoomOutButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ZoomButtons.this.getZoomable().zoomOut(2.0f);
                event.stop();
            }
        });
        this.zoomOutButton.addListener(new TextTooltip(factory.translate("tooltip_zoom_out"), skin));
        this.zoomOutButton.setDisabled(false);
        this.zoomOutButton.setCanCheck(false);
    }

    public Zoomable getZoomable() {
        return this.zoomable;
    }

    public void setZoomable(Zoomable zoomable) {
        this.zoomable = zoomable;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.resetZoomButton.setText(StandardFormats.FACTOR.format(Float.valueOf(this.getZoomable().getCurrentZoom())));
    }

    public void construct() {
        this.add(this.zoomOutButton).padRight(5.0f);
        this.add(this.resetZoomButton).padRight(5.0f);
        this.add(this.zoomInButton);
        this.pack();
    }
}

