/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.ui.commons.widgets.Zoomable;

public class Zoomer
implements Zoomable {
    private float maxScale = 0.2f;
    private float minScale = 0.005f;
    private float initialScale;
    private float scale = this.initialScale = 0.01f;
    private float targetScale = this.initialScale;
    private float scaleDelta = this.initialScale / 10.0f;

    public Zoomer() {
    }

    public Zoomer(float initialScale, float minScale, float maxScale) {
        this.initialScale = initialScale;
        this.targetScale = initialScale;
        this.scale = initialScale;
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.scaleDelta = minScale / maxScale * 3.0f;
    }

    @Override
    public void zoom(float strength) {
        if (strength < 0.0f) {
            this.zoomOut(Math.abs(strength));
        } else {
            this.zoomIn(Math.abs(strength));
        }
    }

    @Override
    public void zoomIn(float strength) {
        this.targetScale = MathUtils.clamp(this.scale + this.scaleDelta * strength, this.minScale, this.maxScale);
    }

    @Override
    public void zoomOut(float strength) {
        this.targetScale = MathUtils.clamp(this.scale - this.scaleDelta * strength, this.minScale, this.maxScale);
    }

    @Override
    public void resetZoom() {
        this.targetScale = this.initialScale;
    }

    @Override
    public float getCurrentZoom() {
        return this.scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void update(float delta) {
        this.scale = MathUtils.lerp(this.scale, this.targetScale, 10.0f * delta);
    }
}

