/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.commons.widgets.dialog;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import java.util.ArrayList;
import java.util.List;

public class DialogBox
extends AstraXComponent {
    public static String PROCEED = "dialog_proceed";
    public static String CANCEL = "dialog_cancel";
    public static String APPLY = "dialog_apply";
    public static String YES = "dialog_yes";
    public static String NO = "dialog_no";
    private Label messageLabel;
    private StaticIcon icon;
    private AstraXTextButton proceedButton;
    private AstraXTextButton cancelButton;
    private List<DialogBoxListener> listeners = new ArrayList<DialogBoxListener>();
    private DialogBoxListener callback;

    public DialogBox(ComponentFactory componentFactory) {
        super(componentFactory, "window-body");
        this.messageLabel = new Label("", componentFactory.getSkin(), "default-no-bg");
        this.messageLabel.setAlignment(1, 1);
        this.proceedButton = new AstraXTextButton(componentFactory, "primary");
        this.proceedButton.setText(componentFactory.translate(PROCEED));
        this.proceedButton.setCanCheck(false);
        this.proceedButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                for (DialogBoxListener listener : DialogBox.this.listeners) {
                    listener.onProceed();
                }
                if (DialogBox.this.getCallback() != null) {
                    DialogBox.this.getCallback().onProceed();
                }
            }
        });
        this.cancelButton = new AstraXTextButton(componentFactory, "secondary");
        this.cancelButton.setText(componentFactory.translate(CANCEL));
        this.cancelButton.setCanCheck(false);
        this.cancelButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                for (DialogBoxListener listener : DialogBox.this.listeners) {
                    listener.onCancel();
                }
                if (DialogBox.this.getCallback() != null) {
                    DialogBox.this.getCallback().onCancel();
                }
            }
        });
        this.icon = new StaticIcon(this.getSkin(), "primary-round-28x28");
    }

    public void addListener(DialogBoxListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(DialogBoxListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private DialogBoxListener getCallback() {
        return this.callback;
    }

    public void setCallback(DialogBoxListener callback) {
        this.callback = callback;
    }

    public void setIcon(String iconName) {
        if (iconName == null) {
            this.icon.setVisible(false);
            return;
        }
        this.icon.setInlineIcon(iconName);
    }

    public void setText(String text) {
        this.messageLabel.setText(text);
        this.pack();
    }

    public void setButtonTexts(String cancelText, String proceedText) {
        this.proceedButton.setText(this.componentFactory.translate(proceedText));
        this.cancelButton.setText(this.componentFactory.translate(cancelText));
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.pad(this.background.getStyle().padding);
        if (this.icon.isVisible()) {
            this.add(this.icon).pad(20.0f).center();
            this.add(this.messageLabel).padTop(20.0f).padRight(20.0f).padBottom(30.0f).top();
            this.row();
            this.add();
        } else {
            this.add(this.messageLabel).padTop(20.0f).padBottom(30.0f).fill();
            this.row();
        }
        Table buttonGroup = new Table();
        buttonGroup.add(this.cancelButton).minWidth(140.0f).right();
        buttonGroup.add().minWidth(120.0f);
        buttonGroup.add(this.proceedButton).minWidth(140.0f).right();
        this.add(buttonGroup).bottom().colspan(2);
        this.pack();
    }

    public static interface DialogBoxListener {
        public void onProceed();

        public void onCancel();
    }
}

