/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.editor.Palette;

public class ButtonPalette<ITEM>
extends Palette<AstraXButton, ITEM> {
    public ButtonPalette(ComponentFactory factory) {
        super(factory);
        this.buttonUpdater = new Palette.ButtonUpdater<AstraXButton, ITEM>(){

            @Override
            public AstraXButton createButton(ComponentFactory componentFactory, String style) {
                return new AstraXButton(componentFactory, style);
            }

            @Override
            public void updateButton(AstraXButton button, ITEM item) {
                button.setUserObject(item);
                if (item instanceof Module) {
                    ModuleSettings moduleSettings = ((Module)item).getModuleSettings();
                    button.getStyle().iconColor.upColor = moduleSettings.color.cpy();
                    button.getStyle().iconColor.checkedColor = moduleSettings.color.cpy().mul(1.1f).clamp();
                    button.setInlineIcon(new TextureRegionDrawable(AstraXApp.astraX.getCoreDataPack().getTexture(moduleSettings.textureRegion)));
                }
            }

            @Override
            public void resetButton(AstraXButton button) {
                button.setInlineIcon(null);
                button.setUserObject(null);
            }
        };
    }
}

