/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.neutronio.astrax.editor.overlays.GradientOverlay;
import com.neutronio.astrax.editor.overlays.IconOverlay;
import com.neutronio.astrax.editor.overlays.Overlay;
import com.neutronio.astrax.gfx.ShapeGraphics;
import com.neutronio.astrax.util.collections.Grid;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class DataLayer
implements ShapeGraphics {
    private Grid<Cell> data = new Grid(1, 1);

    public void clear() {
        for (int x = 0; x < this.data.getWidth(); ++x) {
            for (int y = 0; y < this.data.getHeight(); ++y) {
                if (this.data.isEmpty(x, y)) continue;
                this.data.get((int)x, (int)y).region = null;
                this.data.get((int)x, (int)y).color = null;
            }
        }
    }

    public void update(int x, int y, Overlay overlay) {
        if (overlay instanceof GradientOverlay) {
            this.setColor(x, y, ((GradientOverlay)overlay).apply(x, y));
        }
        if (overlay instanceof IconOverlay) {
            IconOverlay.IconColor icon = ((IconOverlay)overlay).apply(x, y);
            this.setColor(x, y, icon.color);
            this.setRegion(x, y, icon.drawable);
        }
    }

    public void erase(int x, int y) {
        this.setColor(x, y, null);
    }

    public Cell getCell(int x, int y) {
        return this.data.get(x, y);
    }

    public void setColor(int x, int y, Color color) {
        if (this.data.isEmpty(x, y)) {
            return;
        }
        this.data.get((int)x, (int)y).color = color;
    }

    public void setRegion(int x, int y, TextureRegion region) {
        if (this.data.isEmpty(x, y)) {
            return;
        }
        this.data.get((int)x, (int)y).region = region;
    }

    public void resize(int width, int height) {
        this.data = new Grid(width, height);
        for (int x = 0; x < this.data.getWidth(); ++x) {
            for (int y = 0; y < this.data.getHeight(); ++y) {
                this.data.place(x, y, new Cell(x, y));
            }
        }
    }

    public void render(Batch batch, ShapeDrawer shapeDrawer, float x, float y, float scaleX, float scaleY) {
        for (int xTile = 0; xTile < this.data.getWidth(); ++xTile) {
            for (int yTile = 0; yTile < this.data.getHeight(); ++yTile) {
                Cell cell = this.data.get(xTile, yTile);
                if (cell == null || cell.color == null) continue;
                if (cell.region != null) {
                    batch.setColor(cell.color);
                    batch.draw(cell.region, x + (float)(xTile * 16) * scaleX, y + (float)(yTile * 16) * scaleY, 16.0f * scaleX / 2.0f, 16.0f * scaleY / 2.0f, 16.0f * scaleX, 16.0f * scaleY, 1.0f, 1.0f, 0.0f);
                    continue;
                }
                shapeDrawer.setColor(cell.color);
                shapeDrawer.filledRectangle(x + (float)(xTile * 16) * scaleX, y + (float)(yTile * 16) * scaleY, 16.0f * scaleX, 16.0f * scaleY);
            }
        }
        batch.setColor(Color.WHITE);
        shapeDrawer.setColor(Color.WHITE);
    }

    public class Cell {
        public int x;
        public int y;
        public Color color = null;
        public TextureRegion region = null;

        public Cell(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

