/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.screen.MainMenuScreen;
import com.neutronio.astrax.editor.Editor;
import com.neutronio.astrax.editor.LandingPageSettings;
import com.neutronio.astrax.editor.NewSatelliteSettings;
import com.neutronio.astrax.editor.overlays.Overlay;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.editor.toolbox.EditTool;
import com.neutronio.astrax.editor.toolbox.EditorTool;
import com.neutronio.astrax.editor.toolbox.EditorToolBase;
import com.neutronio.astrax.editor.toolbox.InspectionTool;
import com.neutronio.astrax.editor.toolbox.PaintTool;
import com.neutronio.astrax.editor.toolbox.SelectionTool;
import com.neutronio.astrax.input.InputProcessor;
import com.neutronio.astrax.input.actions.KeyTypedAction;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.widgets.MessageLog;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.editor.EditorCell;
import com.neutronio.astrax.ui.editor.EditorGrid;
import com.neutronio.astrax.ui.editor.EditorGridDragger;
import com.neutronio.astrax.ui.editor.EditorHeader;
import com.neutronio.astrax.ui.editor.EditorSidebar;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.editor.actions.LoadFromFileAction;
import com.neutronio.astrax.ui.editor.actions.QuitEditorAction;
import com.neutronio.astrax.ui.editor.actions.SaveAction;
import com.neutronio.astrax.ui.editor.actions.SaveToFileAction;
import com.neutronio.astrax.ui.editor.actions.ShowModalAction;
import com.neutronio.astrax.ui.editor.file.EditorFileDialogCallback;
import com.neutronio.astrax.ui.editor.file.EditorLandingPage;
import com.neutronio.astrax.ui.editor.file.NewSatelliteForm;
import com.neutronio.astrax.ui.editor.spacecraft.SatelliteStatisticsTabs;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.CheckList;
import com.neutronio.astrax.ui.editor.tools.EditCanvasTile;
import com.neutronio.astrax.ui.editor.tools.EditorToolbar;
import com.neutronio.astrax.ui.editor.view.EditorGridOptionsPanel;
import com.neutronio.astrax.ui.editor.view.ViewSettingsTabs;
import com.neutronio.astrax.ui.files.FileDialog;
import com.neutronio.astrax.ui.files.FileDialogForm;
import java.util.logging.Logger;

public class EditorComponent
extends Group {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private InputProcessor<EditorComponent> inputProcessor;
    public static String FILEPATH = "userdata/spacecraft";
    private ComponentFactory componentFactory;
    private EditorHeader editorHeader;
    private EditorToolbar editorToolbar;
    private EditorSidebar editorSidebar;
    private EditorFileDialogCallback editorFileDialogCallback;
    private FileDialogForm fileDialog;
    private Modal<FileDialogForm> fileDialogModal;
    private CheckList checkList;
    private Modal<CheckList> checkListModal;
    private MessageLog editorLog;
    private Modal<MessageLog> editorLogModal;
    private SatelliteStatisticsTabs satelliteStatisticsTabs;
    private Modal<SatelliteStatisticsTabs> satelliteModal;
    private ViewSettingsTabs viewSettingsTabs;
    private Modal<ViewSettingsTabs> viewSettingsTabsModal;
    private NewSatelliteForm newSatelliteForm;
    private Modal<NewSatelliteForm> newSatelliteFormModal;
    private EditorLandingPage editorLandingPage;
    private Modal<EditorLandingPage> editorLandingPageModal;
    private DragListener dragger;
    private EditorGrid editorGrid;
    private Editor editor;
    public SaveToFileAction saveToFileAction;
    public LoadFromFileAction loadFromFileAction;
    public ShowModalAction showViewSettingsAction;
    public ShowModalAction showSatelliteModalAction;
    public ShowModalAction showLogModalAction;
    public ShowModalAction showCheckListModalAction;
    public ShowModalAction showNewSatelliteAction;
    public SaveAction saveAction;
    public QuitEditorAction quitEditorAction;

    public EditorComponent(Editor spacecraftEditor, ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.inputProcessor = new InputProcessor<EditorComponent>(this);
        this.inputProcessor.addAction("astrax:editor:blockRotateLeft", EditorComponent.getBlockRotateLeft());
        this.inputProcessor.addAction("astrax:editor:blockRotateRight", EditorComponent.getBlockRotateRight());
        this.inputProcessor.addAction("astrax:editor:blockErase", EditorComponent.getBlockErase());
        this.editor = spacecraftEditor;
        this.fileDialog = new FileDialogForm(componentFactory, "window-body");
        this.fileDialog.setOriginFolder(FILEPATH);
        this.fileDialog.pack();
        this.fileDialog.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.fileDialog.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() + this.fileDialog.getHeight());
        this.fileDialog.setListener(new FileDialog.FileDialogListener(){

            @Override
            public void onFileLoad(AstraXFiles.AstraXFile file) {
                EditorComponent.this.getEditorFileDialogCallback().onFileLoad(file);
            }

            @Override
            public void onFileSaved(String basePath, String filename) {
                EditorComponent.this.getEditorFileDialogCallback().onFileSaved(EditorComponent.this.editor.getSpacecraft(), basePath, filename);
            }

            @Override
            public void onFileDelete(AstraXFiles.AstraXFile file) {
                EditorComponent.this.getEditorFileDialogCallback().onFileDelete(file);
            }

            @Override
            public void onBack() {
                EditorComponent.this.getEditorFileDialogCallback().onBack();
            }
        });
        this.fileDialogModal = new Modal<FileDialogForm>(componentFactory, this.fileDialog);
        this.fileDialogModal.setHeaderIcon("icon_inline_save");
        this.addActor(this.fileDialogModal);
        this.newSatelliteForm = new NewSatelliteForm(componentFactory);
        this.newSatelliteFormModal = new Modal<NewSatelliteForm>(componentFactory, this.newSatelliteForm);
        this.newSatelliteFormModal.setHeaderText("New Spacecraft");
        this.newSatelliteFormModal.setHeaderIcon("icon_inline_new");
        this.addActor(this.newSatelliteFormModal);
        this.newSatelliteForm.getNewSatellitePanelFormController().addListener(new DefaultFormListener(){

            @Override
            public void onFormSubmit(AbstractForm form) {
                super.onFormSubmit(form);
                EditorComponent.this.onNew(EditorComponent.this.newSatelliteForm.getNewSatellitePanel().getNewSatelliteSettings());
                EditorComponent.this.newSatelliteFormModal.hide();
            }

            @Override
            public void onFormCancel(AbstractForm form) {
                super.onFormCancel(form);
                EditorComponent.this.newSatelliteFormModal.hide();
            }
        });
        this.editorLog = new MessageLog(componentFactory, "window-body", 10);
        this.editorLog.pad(20.0f);
        this.editorLog.setShowTimestamps(true);
        this.editorLog.construct();
        this.editorLogModal = new Modal<MessageLog>(componentFactory, this.editorLog);
        this.editorLogModal.setHeaderText("Editor Log");
        this.editorLogModal.setHeaderIcon("icon_inline_note");
        this.addActor(this.editorLogModal);
        this.editorGrid = new EditorGrid(this.editor, componentFactory);
        this.editorGrid.setSelectionTool(spacecraftEditor.getToolByClass(SelectionTool.class));
        this.editorGrid.setEditorGridListener(new EditorGrid.EditorGridListener(){

            @Override
            public void onGridClicked() {
                EditorComponent.this.performAction();
            }
        });
        this.editorGrid.resizeGrid(5, 5);
        this.editorGrid.setScale(5.0f);
        this.editorGrid.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.editorGrid.getWidth() / 2.0f * this.editorGrid.getScaleX() - 200.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.editorGrid.getHeight() / 2.0f * this.editorGrid.getScaleY());
        this.addActor(this.editorGrid);
        this.editorSidebar = new EditorSidebar(componentFactory, this);
        this.editorSidebar.getStack().setPosition((float)Gdx.graphics.getWidth() - this.editorSidebar.getStack().getWidth() - 10.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.editorSidebar.getStack().getHeight() / 2.0f - 10.0f);
        this.addActor(this.editorSidebar.getStack());
        this.satelliteStatisticsTabs = new SatelliteStatisticsTabs(componentFactory);
        this.satelliteStatisticsTabs.pack();
        this.satelliteModal = new Modal<SatelliteStatisticsTabs>(componentFactory, this.satelliteStatisticsTabs);
        this.satelliteModal.setHeaderText("Craft Statistics");
        this.satelliteModal.setHeaderIcon("icon_inline_chart");
        this.addActor(this.satelliteModal);
        this.viewSettingsTabs = new ViewSettingsTabs(componentFactory);
        this.viewSettingsTabs.pack();
        this.viewSettingsTabsModal = new Modal<ViewSettingsTabs>(componentFactory, this.viewSettingsTabs);
        this.viewSettingsTabsModal.setHeaderText("View Settings");
        this.viewSettingsTabsModal.setHeaderIcon("icon_inline_cog");
        this.addActor(this.viewSettingsTabsModal);
        this.viewSettingsTabs.getEditorGridOptionsPanel().update(this.editorGrid.isShowGrid(), this.editorGrid.isShowConnectors(), this.editorGrid.getConnectorRadius());
        this.viewSettingsTabs.getEditorGridOptionsPanel().setListener(new EditorGridOptionsPanel.EditorGridOptionsPanelListener(){

            @Override
            public void onShowGridChanged(boolean checked) {
                EditorComponent.this.getEditorGrid().setShowGrid(checked);
            }

            @Override
            public void onShowConnectorsChanged(boolean checked) {
                EditorComponent.this.getEditorGrid().setShowConnectors(checked);
            }

            @Override
            public void onSizeSliderChanged(float changedTo) {
                EditorComponent.this.getEditorGrid().setConnectorRadius(changedTo);
            }
        });
        this.dragger = new EditorGridDragger(this.editorGrid);
        this.editorGrid.addListener(this.dragger);
        SelectionTool selectionTool = spacecraftEditor.getToolByClass(SelectionTool.class);
        this.editorGrid.addListener(selectionTool.getCanvasTile());
        selectionTool.getCanvasTile().color = Color.CYAN;
        PaintTool paintTool = spacecraftEditor.getToolByClass(PaintTool.class);
        this.editorGrid.addListener(paintTool.getCanvasTile());
        paintTool.getCanvasTile().color = Color.PURPLE;
        InspectionTool inspectionTool = spacecraftEditor.getToolByClass(InspectionTool.class);
        this.editorGrid.addListener(inspectionTool.getCanvasTile());
        inspectionTool.getCanvasTile().color = Color.OLIVE;
        inspectionTool.getCanvasTile().setParent(this.editorGrid);
        inspectionTool.addListener(new InspectionTool.InspectionToolListener(){

            @Override
            public void onInspectCell(EditorCell selectedCell) {
                EditorComponent.this.editorSidebar.getModuleDetailPanel().update(selectedCell.module);
                EditorComponent.this.editorSidebar.displayTool(InspectionTool.class);
            }
        });
        EditTool editTool = spacecraftEditor.getToolByClass(EditTool.class);
        this.editorGrid.addListener(editTool.getCanvasTile());
        editTool.setEditorGrid(this.editorGrid);
        editTool.addListener(new EditTool.EditToolListener(){

            @Override
            public void onErase(int xTile, int yTile) {
                EditorComponent.this.editorGrid.decreaseBlockCount();
                EditorComponent.this.satelliteStatisticsTabs.update(EditorComponent.this.editor.getSpacecraft());
                EditorComponent.this.checkList.update(EditorComponent.this.editor.getSatelliteValidator());
                EditorComponent.this.checkList.pack();
                EditorComponent.this.checkListModal.pack();
                EditorComponent.this.editorHeader.updateShipStatus(EditorComponent.this.editor.getSatelliteValidator().getMessages());
            }

            @Override
            public void onPlace(int xTile, int yTile, ModuleSettings settings, Orientation orientation, Color color) {
                EditorComponent.this.editorGrid.increaseBlockCount();
                EditorComponent.this.satelliteStatisticsTabs.update(EditorComponent.this.editor.getSpacecraft());
                EditorComponent.this.checkList.update(EditorComponent.this.editor.getSatelliteValidator());
                EditorComponent.this.checkList.pack();
                EditorComponent.this.checkListModal.pack();
                EditorComponent.this.editorHeader.updateShipStatus(EditorComponent.this.editor.getSatelliteValidator().getMessages());
            }
        });
        this.editorLandingPage = new EditorLandingPage(componentFactory);
        this.editorLandingPage.setButtonTexts(componentFactory.translate("form_back"), componentFactory.translate("form_submit"));
        this.editorLandingPage.construct();
        this.editorLandingPageModal = new Modal<EditorLandingPage>(componentFactory, this.editorLandingPage);
        this.editorLandingPageModal.setExitButtonDisabled(true);
        this.editorLandingPageModal.setHeaderText("Editor Launch Pad");
        this.editorLandingPageModal.setHeaderIcon("icon_vessel_medium");
        this.addActor(this.editorLandingPageModal);
        this.checkList = new CheckList(componentFactory);
        this.checkList.pack();
        this.checkListModal = new Modal<CheckList>(componentFactory, this.checkList);
        this.checkListModal.setHeaderText("Checklist");
        this.checkListModal.setHeaderIcon("icon_inline_note");
        this.addActor(this.checkListModal);
        this.loadFromFileAction = new LoadFromFileAction(this.fileDialog, this.fileDialogModal);
        this.saveToFileAction = new SaveToFileAction(this.fileDialog, this.fileDialogModal);
        this.showViewSettingsAction = new ShowModalAction(this.viewSettingsTabsModal);
        this.showSatelliteModalAction = new ShowModalAction(this.satelliteModal);
        this.showLogModalAction = new ShowModalAction(this.editorLogModal);
        this.showCheckListModalAction = new ShowModalAction(this.checkListModal);
        this.saveAction = new SaveAction(this);
        this.quitEditorAction = new QuitEditorAction(this, MainMenuScreen.class);
        this.editorLandingPage.getBackButton().setButtonAction(CustomAction.get(this.quitEditorAction));
        this.editorLandingPage.getStartButton().setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                EditorComponent.this.logger.fine("New Satellite finished!");
                if (EditorComponent.this.editorLandingPage.getValidationStatus().ordinal() == Form.ValidationStatus.VALID.ordinal()) {
                    LandingPageSettings outputSettings = EditorComponent.this.editorLandingPage.getObject();
                    if (outputSettings.newSatelliteSettings != null) {
                        EditorComponent.this.onNew(outputSettings.newSatelliteSettings);
                    } else if (outputSettings.loadSatelliteSettings != null) {
                        EditorComponent.this.editorFileDialogCallback.onFileLoad(outputSettings.loadSatelliteSettings.file);
                    }
                    EditorComponent.this.editorLandingPageModal.hide();
                }
            }
        }));
        Table header = new Table();
        this.editorHeader = new EditorHeader(componentFactory, this);
        this.editorHeader.pack();
        this.editorHeader.left();
        header.add(this.editorHeader).padBottom(5.0f).width(Gdx.graphics.getWidth()).row();
        this.editorToolbar = new EditorToolbar(componentFactory, this.editor, this);
        this.editorToolbar.setWidth(Gdx.graphics.getWidth());
        this.editorToolbar.pack();
        this.editorToolbar.left();
        this.editorToolbar.updateOverlayPicker(this.editor.getOverlays());
        this.editorToolbar.setListener(new EditorToolbar.EditorToolbarListener(){

            @Override
            public void onOverlayChanged(String overlayName, Overlay gradientOverlay) {
                EditorComponent.this.editor.setActiveOverlay(overlayName);
            }
        });
        this.editorToolbar.getEditorTools().setListener(new Palette.PaletteListener<EditorToolBase>(){

            @Override
            public void onSelectedChanged(EditorToolBase selectedItem) {
                if (selectedItem != null) {
                    EditorComponent.this.selectTool(selectedItem);
                }
            }
        });
        header.add(this.editorToolbar).width(Gdx.graphics.getWidth());
        header.left();
        header.setWidth(Gdx.graphics.getWidth());
        header.pack();
        header.setPosition(0.0f, (float)Gdx.graphics.getHeight() - header.getHeight());
        this.addActor(header);
        this.editorToolbar.toFront();
        this.editorHeader.toFront();
        this.satelliteModal.toFront();
        this.viewSettingsTabsModal.toFront();
        this.fileDialogModal.toFront();
        this.editorLandingPageModal.toFront();
        this.editorLogModal.toFront();
        this.newSatelliteFormModal.toFront();
        this.editorFileDialogCallback = new EditorFileDialogCallback(this.fileDialog, this.fileDialogModal, this);
        this.selectTool(editTool);
    }

    public ComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    private void selectTool(EditorToolBase editorTool) {
        if (editorTool != null) {
            if (this.editor.getSelectedTool() != null) {
                this.editor.getSelectedTool().getCanvasTile().active = false;
            }
            this.editor.selectTool(editorTool.getClass());
            this.editor.getSelectedTool().getCanvasTile().active = true;
            this.editorSidebar.displayTool(editorTool.getClass());
        }
    }

    private EditorFileDialogCallback getEditorFileDialogCallback() {
        return this.editorFileDialogCallback;
    }

    protected Editor getEditor() {
        return this.editor;
    }

    public void performAction() {
        EditorTool functionality = this.editorToolbar.getEditorTools().getSelected();
        if (functionality != null) {
            functionality.doAction(this.editorGrid.getData());
        }
    }

    public EditorGrid getEditorGrid() {
        return this.editorGrid;
    }

    public void logAndShowMessage(Message message) {
        this.editorLog.addMessage(message);
        this.editorHeader.setDisplayedHint(message);
        this.editorLog.update();
        this.editorLogModal.getContent().pack();
    }

    public void onNew(NewSatelliteSettings newSpacecraftSettings) {
        this.getEditorGrid().clearData();
        this.getEditorGrid().resizeGrid(newSpacecraftSettings.vesselSize.width, newSpacecraftSettings.vesselSize.height);
        this.getEditorGrid().setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.editorGrid.getWidth() / 2.0f * this.editorGrid.getScaleX() - 200.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.editorGrid.getHeight() / 2.0f * this.editorGrid.getScaleY());
        this.editor.onNew(newSpacecraftSettings);
        this.editorHeader.updateShipStatus(this.editor.getSatelliteValidator().getMessages());
        this.checkList.update(this.editor.getSatelliteValidator());
        this.checkList.pack();
        this.checkListModal.pack();
        this.saveAction.setToSave(this.editor.getSpacecraft(), FILEPATH, newSpacecraftSettings.filename);
        this.satelliteStatisticsTabs.resetValues();
        this.logAndShowMessage(new Message(Message.MessageType.SUCCESS, "New spacecraft created"));
    }

    public void showNewCraftDialog() {
        this.newSatelliteFormModal.show();
    }

    public void showEditorLandingPage() {
        this.editorLandingPageModal.show();
    }

    public void clearSpacecraft() {
        this.editor.clearSpacecraft();
        this.getEditorGrid().clearData();
        this.satelliteStatisticsTabs.resetValues();
        this.editorToolbar.updateOverlayPicker(this.editor.getOverlays());
    }

    public void onLoadSpacecraft(SatelliteGrid satelliteGrid) {
        this.getEditorGrid().clearData();
        this.getEditorGrid().loadSatelliteData(satelliteGrid);
        this.editor.onLoadSpacecraft(satelliteGrid);
        this.satelliteStatisticsTabs.resetValues();
        this.satelliteStatisticsTabs.update(this.editor.getSpacecraft());
        this.checkList.update(this.editor.getSatelliteValidator());
        this.checkList.pack();
        this.checkListModal.pack();
        this.editorHeader.updateShipStatus(this.editor.getSatelliteValidator().getMessages());
        this.editorToolbar.updateOverlayPicker(this.editor.getOverlays());
    }

    public static KeyTypedAction<EditorComponent> getBlockRotateLeft() {
        return new KeyTypedAction<EditorComponent>(){

            @Override
            public boolean doAction(EditorComponent editorComponent) {
                EditTool editTool = editorComponent.editor.getToolByClass(EditTool.class);
                editTool.circleOrientation(1, editTool.getCurrentOrientation());
                EditCanvasTile editCanvasTile = (EditCanvasTile)editTool.getCanvasTile();
                editCanvasTile.apply(editTool.getCellOptions());
                AstraXApp.astraX.getUiSoundManager().playSoundOnce("retract");
                return true;
            }
        };
    }

    public static KeyTypedAction<EditorComponent> getBlockRotateRight() {
        return new KeyTypedAction<EditorComponent>(){

            @Override
            public boolean doAction(EditorComponent editorComponent) {
                EditTool editTool = editorComponent.editor.getToolByClass(EditTool.class);
                editTool.circleOrientation(-1, editTool.getCurrentOrientation());
                EditCanvasTile editCanvasTile = (EditCanvasTile)editTool.getCanvasTile();
                editCanvasTile.apply(editTool.getCellOptions());
                AstraXApp.astraX.getUiSoundManager().playSoundOnce("retract");
                return true;
            }
        };
    }

    public static KeyTypedAction<EditorComponent> getBlockErase() {
        return new KeyTypedAction<EditorComponent>(){

            @Override
            public boolean doAction(EditorComponent editorComponent) {
                EditTool editTool = editorComponent.editor.getToolByClass(EditTool.class);
                editTool.toggleMode();
                editorComponent.editorSidebar.getPaintToolSettingsPanel().setEraserCheckBoxState(editTool.erase);
                return true;
            }
        };
    }

    public InputProcessor<EditorComponent> getInputProcessor() {
        return this.inputProcessor;
    }

    public SatelliteGrid getSpacecraft() {
        return this.editor.getSpacecraft();
    }
}

