/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.editor.Editor;
import com.neutronio.astrax.editor.placement.Connector;
import com.neutronio.astrax.editor.placement.DefaultPlacementValidator;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.editor.toolbox.SelectionTool;
import com.neutronio.astrax.gfx.ShapeGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.widgets.Zoomable;
import com.neutronio.astrax.ui.commons.widgets.Zoomer;
import com.neutronio.astrax.ui.editor.EditorCell;
import com.neutronio.astrax.util.Vector2i;
import com.neutronio.astrax.util.collections.Grid;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class EditorGrid
extends Actor
implements Zoomable,
ShapeGraphics {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private boolean showGrid = true;
    private boolean showConnectors = true;
    private float connectorRadius = 10.0f;
    private ComponentFactory componentFactory;
    private Editor editor;
    private int placedBlocks = 0;
    private float time;
    private Zoomer zoomer;
    private Grid<EditorCell> data;
    private EditorGridListener editorGridListener;
    public DefaultPlacementValidator placementValidator = new DefaultPlacementValidator();
    private SelectionTool selectionTool;

    public EditorGrid(Editor editor, ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.editor = editor;
        this.zoomer = new Zoomer(2.0f, 2.0f, 5.0f);
        this.addListener(new ClickListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                EditorGrid.this.logger.fine("Scrolled");
                EditorGrid.this.zoom(-0.5f * Math.signum(amountY));
                return super.scrolled(event, x, y, amountX, amountY);
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                EditorGrid.this.editorGridListener.onGridClicked();
                event.stop();
            }
        });
        this.addListener(new ClickListener(1){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                EditorGrid.this.editorGridListener.onGridClicked();
                super.clicked(event, x, y);
            }
        });
    }

    public boolean isFirstBlock() {
        return this.placedBlocks == 0;
    }

    public void increaseBlockCount() {
        ++this.placedBlocks;
    }

    public void decreaseBlockCount() {
        --this.placedBlocks;
    }

    @Override
    public void zoom(float strength) {
        this.zoomer.zoom(strength);
    }

    @Override
    public void zoomIn(float strength) {
        this.zoomer.zoomIn(strength);
    }

    @Override
    public void zoomOut(float strength) {
        this.zoomer.zoomOut(strength);
    }

    @Override
    public void resetZoom() {
        this.zoomer.resetZoom();
    }

    @Override
    public float getCurrentZoom() {
        return this.zoomer.getCurrentZoom();
    }

    public int getWidthInTiles() {
        return this.data.getWidth();
    }

    public int getHeightInTiles() {
        return this.data.getHeight();
    }

    public void resizeGrid(int width, int height) {
        this.data = new Grid(width, height);
        for (int x = 0; x < this.data.getWidth(); ++x) {
            for (int y = 0; y < this.data.getHeight(); ++y) {
                this.data.place(x, y, new EditorCell(x, y));
            }
        }
        this.placedBlocks = 0;
        this.setSize(width * 16, height * 16);
    }

    public void setSelectionTool(SelectionTool selectionTool) {
        this.selectionTool = selectionTool;
    }

    public void setEditorGridListener(EditorGridListener editorGridListener) {
        this.editorGridListener = editorGridListener;
    }

    public Grid<EditorCell> getData() {
        return this.data;
    }

    public List<AdjacentTile> findAdjacentTiles(int xTile, int yTile) {
        ArrayList<AdjacentTile> adjacentCells = new ArrayList<AdjacentTile>();
        for (Orientation orientation : Orientation.values()) {
            EditorCell editorCell = this.data.get(xTile + orientation.getxDir(), yTile + orientation.getyDir());
            if (editorCell == null || editorCell.module == null) continue;
            adjacentCells.add(new AdjacentTile(editorCell, orientation));
        }
        return adjacentCells;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.render(batch, this.componentFactory.getHudRenderContext().getShapeDrawer());
        if (this.editor.getDataLayer() != null) {
            this.editor.getDataLayer().render(batch, this.componentFactory.getHudRenderContext().getShapeDrawer(), this.getX(), this.getY(), this.getScaleX(), this.getScaleY());
        }
        if (this.editor.getSelectedTool() != null) {
            this.editor.getSelectedTool().getCanvasTile().render(batch, this.componentFactory.getHudRenderContext().getShapeDrawer(), this.getX(), this.getY(), this.getScaleX(), this.getScaleY(), this.time);
        }
    }

    public void render(Batch batch, ShapeDrawer shapeDrawer) {
        EditorCell cell;
        int x;
        float delta = Gdx.graphics.getDeltaTime();
        this.time += delta * 3.0f;
        this.zoomer.update(delta);
        this.setScale(this.zoomer.getCurrentZoom(), this.zoomer.getCurrentZoom());
        shapeDrawer.setColor(Color.GOLD.r, Color.GOLD.g, Color.GOLD.b, MathUtils.lerp(0.2f, 0.7f, Interpolation.sine.apply(this.time)));
        if (this.selectionTool != null) {
            for (Vector2i selectedCell : this.selectionTool.getSelected()) {
                shapeDrawer.filledRectangle(this.getX() + (float)(selectedCell.x * 16) * this.getScaleX(), this.getY() + (float)(selectedCell.y * 16) * this.getScaleY(), 16.0f * this.getScaleX(), 16.0f * this.getScaleY());
            }
        }
        if (this.showGrid) {
            shapeDrawer.setDefaultLineWidth(1.0f);
            shapeDrawer.setColor(Color.GRAY.r, Color.GRAY.g, Color.GRAY.b, 0.8f);
            for (int x2 = 0; x2 < this.data.getWidth() + 1; ++x2) {
                shapeDrawer.line(this.getX() + (float)(x2 * 16) * this.getScaleX(), this.getY(), this.getX() + (float)(x2 * 16) * this.getScaleX(), this.getY() + (float)(this.data.getHeight() * 16) * this.getScaleY());
                for (int y = 0; y < this.data.getHeight() + 1; ++y) {
                    shapeDrawer.line(this.getX(), this.getY() + (float)(y * 16) * this.getScaleY(), this.getX() + (float)(this.data.getWidth() * 16) * this.getScaleX(), this.getY() + (float)(y * 16) * this.getScaleY());
                }
            }
        }
        for (x = 0; x < this.data.getWidth(); ++x) {
            for (int y = 0; y < this.data.getHeight(); ++y) {
                cell = this.data.get(x, y);
                cell.alphaTweening = MathUtils.lerp(cell.alphaTweening, cell.targetAlphaTweening, 0.2f);
                if (cell.region == null) continue;
                cell.scaleTweening = MathUtils.lerp(cell.scaleTweening, cell.targetScaleTweening, 0.2f);
                batch.setColor(cell.color.r, cell.color.g, cell.color.b, cell.alphaTweening);
                batch.draw(cell.region, this.getX() + (float)(x * 16) * this.getScaleX(), this.getY() + (float)(y * 16) * this.getScaleY(), 16.0f * this.getScaleX() / 2.0f, 16.0f * this.getScaleY() / 2.0f, 16.0f * this.getScaleX(), 16.0f * this.getScaleY(), cell.scaleTweening, cell.scaleTweening, -cell.orientation.getRotationDegrees());
            }
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        if (this.showConnectors) {
            shapeDrawer.setColor(Color.GREEN.r, Color.GREEN.g, Color.GREEN.b, 0.8f);
            for (x = 0; x < this.data.getWidth(); ++x) {
                for (int y = 0; y < this.data.getHeight(); ++y) {
                    cell = this.data.get(x, y);
                    if (cell.region == null || cell.connector == null) continue;
                    this.drawConnector(shapeDrawer, cell.connector, (float)(cell.x * 16) * this.getScaleX(), (float)(cell.y * 16) * this.getScaleX(), this.connectorRadius / 2.0f);
                }
            }
        }
    }

    public void drawConnector(ShapeDrawer shapeDrawer, Connector connector, float x, float y, float radius) {
        if (connector.isNorth()) {
            shapeDrawer.circle(this.getX() + x + 8.0f * this.getScaleX(), this.getY() + y + 16.0f * this.getScaleY(), radius);
        }
        if (connector.isEast()) {
            shapeDrawer.circle(this.getX() + x + 16.0f * this.getScaleX(), this.getY() + y + 8.0f * this.getScaleY(), radius);
        }
        if (connector.isSouth()) {
            shapeDrawer.circle(this.getX() + x + 8.0f * this.getScaleX(), this.getY() + y, radius);
        }
        if (connector.isWest()) {
            shapeDrawer.circle(this.getX() + x, this.getY() + y + 8.0f * this.getScaleY(), radius);
        }
    }

    public void loadSatelliteData(SatelliteGrid satelliteGrid) {
        this.resizeGrid(satelliteGrid.vesselSize.width, satelliteGrid.vesselSize.height);
        Grid<SatelliteGrid.SatelliteGridSettings> data = satelliteGrid.getData();
        for (int x = 0; x < data.getWidth(); ++x) {
            for (int y = 0; y < data.getHeight(); ++y) {
                EditorCell cell = this.data.get(x, y);
                SatelliteGrid.SatelliteGridSettings settings = satelliteGrid.getData().get(x, y);
                if (settings == null) continue;
                Connector connector = settings.moduleSettings.connector.copy();
                connector.rotate(settings.orientation.getRotationDegrees());
                cell.region = AstraXApp.astraX.getCoreDataPack().getTexture(settings.moduleSettings.textureRegion);
                cell.module = settings.moduleSettings;
                cell.connector = connector;
                cell.orientation = settings.orientation;
                cell.color = settings.tint;
                cell.scaleTweening = 3.0f;
                cell.targetScaleTweening = 1.0f;
                cell.alphaTweening = 0.2f;
                cell.targetAlphaTweening = 1.0f;
                ++this.placedBlocks;
            }
        }
    }

    public void clearData() {
        this.placedBlocks = 0;
        for (int x = 0; x < this.data.getWidth(); ++x) {
            for (int y = 0; y < this.data.getHeight(); ++y) {
                EditorCell cell = this.data.get(x, y);
                cell.region = null;
                cell.module = null;
                cell.connector = null;
                cell.orientation = Orientation.NORTH;
                cell.color = Color.WHITE;
            }
        }
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public boolean isShowConnectors() {
        return this.showConnectors;
    }

    public void setShowConnectors(boolean showConnectors) {
        this.showConnectors = showConnectors;
    }

    public float getConnectorRadius() {
        return this.connectorRadius;
    }

    public void setConnectorRadius(float connectorRadius) {
        this.connectorRadius = connectorRadius;
    }

    public static interface EditorGridListener {
        public void onGridClicked();
    }

    public static class AdjacentTile {
        public EditorCell cell;
        public Orientation orientation;

        public AdjacentTile(EditorCell cell, Orientation orientation) {
            this.cell = cell;
            this.orientation = orientation;
        }
    }
}

