/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.neutronio.astrax.ui.editor.EditorGrid;

public class EditorGridDragger
extends DragListener {
    protected EditorGrid editorGrid;
    protected float xMax;
    protected float xMin;
    protected float yMax;
    protected float yMin;

    public EditorGridDragger(EditorGrid editorGrid) {
        this.editorGrid = editorGrid;
    }

    @Override
    public void drag(InputEvent event, float x, float y, int pointer) {
        super.drag(event, x, y, pointer);
        this.xMax = (float)Gdx.graphics.getWidth() + this.editorGrid.getScaleX() * (float)(this.editorGrid.getWidthInTiles() * 16);
        this.xMin = -(this.editorGrid.getScaleX() * (this.editorGrid.getWidth() / 2.0f));
        this.yMax = (float)Gdx.graphics.getHeight() + this.editorGrid.getScaleY() * (float)(this.editorGrid.getHeightInTiles() * 16);
        this.yMin = -(this.editorGrid.getScaleY() * (this.editorGrid.getHeight() / 2.0f));
        this.editorGrid.setPosition(MathUtils.clamp(this.getDragX() + this.editorGrid.getX() - this.getDragStartX(), this.xMin, this.xMax), MathUtils.clamp(this.getDragY() + this.editorGrid.getY() - this.getDragStartY(), this.yMin, this.yMax));
    }
}

