/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.menu.DropdownMenu;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.editor.EditorComponent;
import com.neutronio.astrax.ui.editor.actions.EmptyAction;
import com.neutronio.astrax.ui.editor.actions.LoadFromFileAction;
import com.neutronio.astrax.ui.editor.actions.QuitEditorAction;
import com.neutronio.astrax.ui.editor.actions.SaveAction;
import com.neutronio.astrax.ui.editor.actions.SaveToFileAction;
import com.neutronio.astrax.ui.editor.actions.ShowModalAction;
import com.neutronio.astrax.ui.editor.header.CheckListStatus;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.List;

public class EditorHeader
extends SimplePanel {
    private IconLabel messageLabel;
    private DropdownMenu topDropDown;
    private EditorComponent editorComponent;
    private CheckListStatus checkListStatus;

    public EditorHeader(ComponentFactory componentFactory, EditorComponent editor) {
        super(componentFactory, "default", "window-header");
        this.pad(5.0f, 2.0f, 5.0f, 2.0f);
        this.editorComponent = editor;
        this.messageLabel = new IconLabel(componentFactory, "empty");
        this.messageLabel.pack();
        this.topDropDown = new DropdownMenu(componentFactory);
        this.topDropDown.addDropDown(this.getTranslation("spacecraft_editor_file"), new SelectBoxWrapper[]{new SelectBoxWrapper<1>(this.getTranslation("spacecraft_editor_file_new"), new Runnable(){

            @Override
            public void run() {
                EditorHeader.this.editorComponent.showNewCraftDialog();
            }
        }), new SelectBoxWrapper<SaveAction>(this.getTranslation("spacecraft_editor_file_save"), this.editorComponent.saveAction), new SelectBoxWrapper<SaveToFileAction>(this.getTranslation("spacecraft_editor_file_save_as"), this.editorComponent.saveToFileAction), new SelectBoxWrapper<LoadFromFileAction>(this.getTranslation("spacecraft_editor_file_load"), this.editorComponent.loadFromFileAction), new SelectBoxWrapper<QuitEditorAction>(this.getTranslation("spacecraft_editor_file_quit"), this.editorComponent.quitEditorAction)});
        this.topDropDown.addDropDown(this.getTranslation("spacecraft_editor_edit"), new SelectBoxWrapper[]{new SelectBoxWrapper<EmptyAction>(this.getTranslation("spacecraft_editor_edit_undo"), new EmptyAction(this.editorComponent)), new SelectBoxWrapper<EmptyAction>(this.getTranslation("spacecraft_editor_edit_redo"), new EmptyAction(this.editorComponent)), new SelectBoxWrapper<EmptyAction>(this.getTranslation("spacecraft_editor_edit_cut"), new EmptyAction(this.editorComponent)), new SelectBoxWrapper<EmptyAction>(this.getTranslation("spacecraft_editor_edit_copy"), new EmptyAction(this.editorComponent)), new SelectBoxWrapper<EmptyAction>(this.getTranslation("spacecraft_editor_edit_paste"), new EmptyAction(this.editorComponent))});
        this.topDropDown.addDropDown(this.getTranslation("spacecraft_editor_view"), new SelectBoxWrapper[]{new SelectBoxWrapper<ShowModalAction>(this.getTranslation("spacecraft_editor_view_grid"), this.editorComponent.showViewSettingsAction), new SelectBoxWrapper<ShowModalAction>(this.getTranslation("spacecraft_editor_view_log"), this.editorComponent.showLogModalAction)});
        this.topDropDown.addDropDown(this.getTranslation("spacecraft_editor_satellite"), new SelectBoxWrapper[]{new SelectBoxWrapper<ShowModalAction>(this.getTranslation("spacecraft_editor_satellite_checklist"), this.editorComponent.showCheckListModalAction), new SelectBoxWrapper<ShowModalAction>(this.getTranslation("spacecraft_editor_satellite_statistics"), this.editorComponent.showSatelliteModalAction)});
        this.topDropDown.setSize(this.topDropDown.getButtons().getWidth(), this.topDropDown.getButtons().getHeight());
        this.topDropDown.setPosition(0.0f, (float)Gdx.graphics.getHeight() - this.topDropDown.getButtons().getHeight());
        this.add(this.topDropDown).pad(0.0f).fill();
        this.checkListStatus = new CheckListStatus(componentFactory);
        HorizontalGroup statusGroup = new HorizontalGroup();
        statusGroup.pad(0.0f, 5.0f, 0.0f, 5.0f);
        statusGroup.space(5.0f);
        Image shipIcon = new Image(componentFactory.getSkin(), "icon_inline_ship");
        shipIcon.setSize(24.0f, 24.0f);
        statusGroup.addActor(shipIcon);
        statusGroup.addActor(this.checkListStatus);
        this.add(statusGroup).center().padLeft(10.0f).padRight(10.0f);
        this.add(this.messageLabel).top().center();
        this.pack();
    }

    public void updateShipStatus(List<Message> messages) {
        this.checkListStatus.update(messages);
    }

    public void setDisplayedHint(Message message) {
        this.messageLabel.setStyle(this.getSkin().get(message.getType().toIconLabelStyle(), IconLabel.IconLabelStyle.class));
        this.messageLabel.setText(message.getMessage());
        this.messageLabel.addAction(Tweening.getGrowlAnimation(7.0f));
    }

    public DropdownMenu getTopDropDown() {
        return this.topDropDown;
    }
}

