/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.editor.toolbox.EditTool;
import com.neutronio.astrax.editor.toolbox.InspectionTool;
import com.neutronio.astrax.editor.toolbox.PaintTool;
import com.neutronio.astrax.editor.toolbox.SelectionTool;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.widgets.DynamicInfoComponent;
import com.neutronio.astrax.ui.editor.EditorComponent;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.editor.tools.EditCanvasTile;
import com.neutronio.astrax.ui.editor.tools.EditToolPanel;
import com.neutronio.astrax.ui.editor.tools.InspectionToolPanel;
import com.neutronio.astrax.ui.editor.tools.ModuleDetailPanel;
import com.neutronio.astrax.ui.editor.tools.PaintToolPanel;
import com.neutronio.astrax.ui.editor.tools.SelectionToolPanel;
import java.util.logging.Logger;

public class EditorSidebar {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private EditorComponent editorComponent;
    private DynamicInfoComponent dynamicInfoComponent;
    private EditToolPanel editToolPanel;
    private SelectionToolPanel selectionToolPanel;
    private InspectionToolPanel inspectionToolPanel;
    private PaintToolPanel paintToolPanel;

    public EditorSidebar(ComponentFactory componentFactory, EditorComponent editor) {
        this.dynamicInfoComponent = new DynamicInfoComponent(componentFactory);
        this.editorComponent = editor;
        this.editToolPanel = new EditToolPanel(componentFactory);
        this.editToolPanel.construct();
        this.editToolPanel.pack();
        this.editToolPanel.align(2);
        this.selectionToolPanel = new SelectionToolPanel(componentFactory);
        this.selectionToolPanel.construct();
        this.selectionToolPanel.align(2);
        this.inspectionToolPanel = new InspectionToolPanel(componentFactory);
        this.inspectionToolPanel.construct();
        this.inspectionToolPanel.align(2);
        this.paintToolPanel = new PaintToolPanel(componentFactory);
        this.paintToolPanel.construct();
        this.paintToolPanel.align(2);
        this.dynamicInfoComponent.putDetailComponent(this.editToolPanel, EditTool.class);
        this.dynamicInfoComponent.putDetailComponent(this.selectionToolPanel, SelectionTool.class);
        this.dynamicInfoComponent.putDetailComponent(this.inspectionToolPanel, InspectionTool.class);
        this.dynamicInfoComponent.putDetailComponent(this.paintToolPanel, PaintTool.class);
        this.dynamicInfoComponent.pack();
        this.selectionToolPanel.setSelectionSettingsPanelListener(new SelectionToolPanel.SelectionSettingsPanelListener(){

            @Override
            public void onInverseSelection() {
                SelectionTool selectionTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(SelectionTool.class);
                selectionTool.inverseSelection(EditorSidebar.this.editorComponent.getEditorGrid().getWidthInTiles(), EditorSidebar.this.editorComponent.getEditorGrid().getHeightInTiles());
            }

            @Override
            public void onDeselectAll() {
                SelectionTool selectionTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(SelectionTool.class);
                selectionTool.deselectAll();
            }

            @Override
            public void onSelectBlocks() {
                SelectionTool selectionTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(SelectionTool.class);
                selectionTool.selectBlocks(EditorSidebar.this.editorComponent.getSpacecraft());
            }
        });
        this.editToolPanel.getModulePalette().getPalette().setListener(new Palette.PaletteListener<ModuleSettings>(){

            @Override
            public void onSelectedChanged(ModuleSettings selectedItem) {
                EditTool editTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(EditTool.class);
                if (selectedItem != null) {
                    EditorSidebar.this.logger.finest("Module changed: " + selectedItem.name);
                    EditorSidebar.this.editorComponent.getEditor().getToolByClass(EditTool.class).setCurrentModule(selectedItem);
                    EditCanvasTile editCanvasTile = (EditCanvasTile)editTool.getCanvasTile();
                    editCanvasTile.apply(editTool.getCellOptions());
                    EditorSidebar.this.editToolPanel.setModuleName(selectedItem.name);
                } else {
                    EditorSidebar.this.editorComponent.getEditor().getToolByClass(EditTool.class).setCurrentModule(null);
                    EditCanvasTile editCanvasTile = (EditCanvasTile)editTool.getCanvasTile();
                    editCanvasTile.apply(editTool.getCellOptions());
                    EditorSidebar.this.editToolPanel.setModuleName("-");
                }
            }
        });
        this.editToolPanel.setListener(new EditToolPanel.PaintToolSettingsListener(){

            @Override
            public void onEraserChecked(boolean enabled) {
                EditorSidebar.this.logger.finest("Eraser enabled: " + enabled);
                if (enabled) {
                    EditorSidebar.this.editorComponent.getEditor().getToolByClass(EditTool.class).setModeErase();
                } else {
                    EditorSidebar.this.editorComponent.getEditor().getToolByClass(EditTool.class).setModePlace();
                }
            }

            @Override
            public void onOrientationChanged(Orientation orientation) {
                EditorSidebar.this.logger.finest("Orientation changed: " + (Object)((Object)orientation));
                if (EditorSidebar.this.editToolPanel.getModulePalette().getPalette().getSelected() != null) {
                    EditTool editTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(EditTool.class);
                    editTool.changeOrientation(orientation);
                    EditCanvasTile editCanvasTile = (EditCanvasTile)editTool.getCanvasTile();
                    editCanvasTile.apply(editTool.getCellOptions());
                }
            }
        });
        this.paintToolPanel.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                PaintTool paintTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(PaintTool.class);
                paintTool.setSelectedColor(EditorSidebar.this.paintToolPanel.getSelectedColor());
            }
        });
        this.paintToolPanel.setListener(new PaintToolPanel.PaintToolPanelListener(){

            @Override
            public void onPaintSelected(Color withColor) {
                SelectionTool selectionTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(SelectionTool.class);
                PaintTool paintTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(PaintTool.class);
                paintTool.paintSelected(EditorSidebar.this.editorComponent.getEditorGrid().getData(), selectionTool.getSelected());
            }

            @Override
            public void onResetSelected() {
                SelectionTool selectionTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(SelectionTool.class);
                PaintTool paintTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(PaintTool.class);
                paintTool.resetPaintSelected(EditorSidebar.this.editorComponent.getEditorGrid().getData(), selectionTool.getSelected());
            }

            @Override
            public void onSelectedColorChanged(Color toColor) {
                if (toColor == null) {
                    return;
                }
                PaintTool paintTool = EditorSidebar.this.editorComponent.getEditor().getToolByClass(PaintTool.class);
                paintTool.getCanvasTile().color = toColor;
            }
        });
        this.dynamicInfoComponent.initStackController();
    }

    public Stack getStack() {
        return this.dynamicInfoComponent.getDetailComponentStack();
    }

    public void displayTool(Class toolClass) {
        this.dynamicInfoComponent.showDetailComponentFor(toolClass);
    }

    public EditToolPanel getPaintToolSettingsPanel() {
        return this.editToolPanel;
    }

    public SelectionToolPanel getSelectionSettingsPanel() {
        return this.selectionToolPanel;
    }

    public ModuleDetailPanel getModuleDetailPanel() {
        return this.inspectionToolPanel.getModuleDetailPanel();
    }
}

