/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettingsRepository;
import com.neutronio.astrax.editor.filter.ModuleFunctionType;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.editor.ButtonPalette;
import com.neutronio.astrax.ui.editor.Palette;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ModulePalette
extends HorizontalGroup {
    private ButtonPalette<ModuleSettings> palette;
    private Table filterGroup;
    private ButtonGroup<AstraXButton> filterButtonGroup;
    private ModuleSettingsRepository moduleRepository;
    private ModuleSettingsComparator moduleSettingsComparator = new ModuleSettingsComparator();
    private char[] activeFilters;

    public ModulePalette(ComponentFactory componentFactory) {
        this.space(10.0f);
        this.activeFilters = new char[ModuleFunctionType.values().length];
        for (int i2 = 0; i2 < this.activeFilters.length; ++i2) {
            this.activeFilters[i2] = 48;
        }
        this.moduleRepository = AstraXApp.astraX.getRepository(ModuleSettingsRepository.class);
        this.palette = new ButtonPalette(componentFactory);
        this.palette.setPrefIconSize(64);
        List allModules = this.moduleRepository.all();
        Collections.sort(allModules, this.moduleSettingsComparator);
        for (ModuleSettings moduleSettings : allModules) {
            this.palette.addItem(moduleSettings, AstraXApp.astraX.getCoreDataPack().getTexture(moduleSettings.textureRegion), moduleSettings.color.cpy());
        }
        this.palette.setButtonProducer(new Palette.ButtonUpdater<AstraXButton, ModuleSettings>(){

            @Override
            public AstraXButton createButton(ComponentFactory componentFactory, String style) {
                return new AstraXButton(componentFactory, style);
            }

            @Override
            public void updateButton(AstraXButton button, ModuleSettings item) {
                button.setUserObject(item);
                button.getStyle().iconColor.upColor = item.color.cpy();
                button.getStyle().iconColor.checkedColor = item.color.cpy().mul(1.1f).clamp();
                button.setInlineIcon(new TextureRegionDrawable(AstraXApp.astraX.getCoreDataPack().getTexture(item.textureRegion)));
            }

            @Override
            public void resetButton(AstraXButton button) {
                button.setInlineIcon(null);
                button.setUserObject(null);
            }
        });
        this.palette.setIconCount(15);
        this.palette.setColumns(5);
        this.palette.fillWithButtons("editor-palette");
        this.palette.updateToContent();
        this.filterButtonGroup = new ButtonGroup();
        this.filterButtonGroup.setMaxCheckCount(0);
        this.filterButtonGroup.setMinCheckCount(0);
        this.filterGroup = new Table();
        for (ModuleFunctionType moduleFunctionType : ModuleFunctionType.values()) {
            final AstraXButton button = new AstraXButton(componentFactory, moduleFunctionType.iconName, "editor-palette-filter");
            Tooltip<Label> tooltip = new Tooltip<Label>(new Label("Filter by: " + moduleFunctionType.name(), componentFactory.getSkin(), "tooltip"));
            button.setUserObject((Object)moduleFunctionType);
            button.addListener(tooltip);
            button.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    ModuleFunctionType function = (ModuleFunctionType)((Object)event.getTarget().getUserObject());
                    ((ModulePalette)ModulePalette.this).activeFilters[function.ordinal()] = button.isChecked() ? 49 : 48;
                    ModulePalette.this.updateFilters();
                }
            });
            this.filterButtonGroup.add(button);
            if (moduleFunctionType.ordinal() % 2 == 0) {
                this.filterGroup.row();
            }
            this.filterGroup.add(button);
        }
        this.filterGroup.align(2);
        this.addActor(this.filterGroup);
        this.addActor(this.palette);
    }

    public void updateFilters() {
        ArrayList<ModuleFunctionType> functions = new ArrayList<ModuleFunctionType>();
        int i2 = 0;
        for (char c : this.activeFilters) {
            if (c == '1') {
                functions.add(ModuleFunctionType.values()[i2]);
            }
            ++i2;
        }
        List<ModuleSettings> filteredList = this.moduleRepository.findBy(functions.toArray(new ModuleFunctionType[0]));
        Collections.sort(filteredList, this.moduleSettingsComparator);
        this.palette.setItems(filteredList);
    }

    public Palette getPalette() {
        return this.palette;
    }

    public static class ModuleSettingsComparator
    implements Comparator<ModuleSettings> {
        @Override
        public int compare(ModuleSettings o1, ModuleSettings o2) {
            return o1.name.compareTo(o2.name);
        }
    }
}

