/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.widgets.DefaultPaginator;
import com.neutronio.astrax.ui.commons.widgets.Paginator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class Palette<BUTTON extends Button, ITEM>
extends AstraXComponent
implements Paginator {
    protected Logger logger = Logger.getLogger(Palette.class.getCanonicalName());
    protected int prefIconSize = 24;
    protected int iconCount = 25;
    protected int columns = 5;
    protected DefaultPaginator defaultPaginator = new DefaultPaginator();
    protected List<ITEM> content = new ArrayList<ITEM>();
    protected List<BUTTON> buttons = new ArrayList<BUTTON>();
    protected PaletteListener<ITEM> listener;
    protected ButtonUpdater<BUTTON, ITEM> buttonUpdater;
    protected ButtonGroup<Button> buttonGroup = new ButtonGroup();

    public void setButtonProducer(ButtonUpdater<BUTTON, ITEM> buttonUpdater) {
        this.buttonUpdater = buttonUpdater;
    }

    public Palette(ComponentFactory factory) {
        super(factory);
        this.buttonGroup.setMaxCheckCount(1);
        this.buttonGroup.setMinCheckCount(1);
        this.buttonGroup.setUncheckLast(true);
    }

    public ButtonGroup<Button> getButtonGroup() {
        return this.buttonGroup;
    }

    public List<ITEM> getContent() {
        return this.content;
    }

    public void setListener(PaletteListener<ITEM> listener) {
        this.listener = listener;
    }

    public int getIconCount() {
        return this.iconCount;
    }

    public int getItemCount() {
        return this.content.size();
    }

    public void setIconCount(int iconCount) {
        this.iconCount = iconCount;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    @Override
    public int getCurrentPage() {
        return this.defaultPaginator.getCurrentPage();
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.defaultPaginator.setCurrentPage(currentPage);
        this.updateToContent();
    }

    public int getPrefIconSize() {
        return this.prefIconSize;
    }

    public void setPrefIconSize(int prefIconSize) {
        this.prefIconSize = prefIconSize;
    }

    public void setButtonGroup(ButtonGroup<Button> buttonGroup) {
        this.buttonGroup = buttonGroup;
    }

    public void fillWithButtons(String astraXButtonStyle) {
        for (int i2 = 0; i2 < this.iconCount; ++i2) {
            BUTTON button = this.buttonUpdater.createButton(this.componentFactory, astraXButtonStyle);
            if (this.buttonGroup != null) {
                this.buttonGroup.add((Button)button);
            }
            this.buttons.add(button);
            if (button instanceof Actor) {
                Actor buttonActor = (Actor)button;
                buttonActor.addListener(new ClickListener((Button)button){
                    final /* synthetic */ Button val$button;
                    {
                        this.val$button = button;
                    }

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        if (Palette.this.getListener() != null && !this.val$button.isDisabled() && !event.isStopped()) {
                            Palette.this.getListener().onSelectedChanged(((Actor)((Object)this.val$button)).getUserObject());
                        }
                    }
                });
                this.add((Actor)button).center().padRight(5.0f).padBottom(5.0f);
            }
            if (this.buttons.size() % this.columns != 0) continue;
            this.row();
        }
        this.defaultPaginator.configure(this.content.size(), this.iconCount);
    }

    public void updateToContent() {
        this.defaultPaginator.configure(this.content.size(), this.iconCount);
        int startIndex = (this.defaultPaginator.getCurrentPage() - 1) * this.buttons.size();
        int buttonIndex = 0;
        for (Button button : this.buttons) {
            this.buttonUpdater.resetButton(button);
        }
        for (int i2 = startIndex; i2 < startIndex + this.content.size() && i2 < this.content.size() && buttonIndex < this.buttons.size(); ++buttonIndex, ++i2) {
            Button button;
            button = (Button)this.buttons.get(buttonIndex);
            this.buttonUpdater.updateButton(button, this.content.get(i2));
        }
        this.pack();
    }

    public void setSelected(ITEM item) {
        int contentIndex = this.content.indexOf(item);
        int page = contentIndex / this.columns;
        this.defaultPaginator.setCurrentPage(page + 1);
        int buttonIndex = contentIndex - page * this.buttons.size();
        if (this.buttonGroup != null) {
            this.buttonGroup.uncheckAll();
        }
        int i2 = 0;
        for (Button button : this.buttons) {
            if (buttonIndex == i2) {
                button.setChecked(true);
            } else {
                button.setChecked(false);
            }
            ++i2;
        }
    }

    public void setSelectedIndex(int contentIndex) {
        if (contentIndex < 0) {
            if (this.buttonGroup != null) {
                this.buttonGroup.uncheckAll();
            }
        } else {
            int page = contentIndex / this.columns;
            this.defaultPaginator.setCurrentPage(page + 1);
            int buttonIndex = contentIndex - page * this.buttons.size();
            if (this.buttonGroup != null) {
                this.buttonGroup.uncheckAll();
            }
            int i2 = 0;
            for (Button button : this.buttons) {
                if (buttonIndex == i2) {
                    button.setChecked(true);
                } else {
                    button.setChecked(false);
                }
                ++i2;
            }
        }
    }

    public void removeItem(ITEM item) {
        this.content.remove(item);
    }

    public void addItem(ITEM item) {
        this.content.add(item);
    }

    public void addItems(List<ITEM> items) {
        this.content.addAll(items);
    }

    @Deprecated
    public void addItem(ITEM item, TextureRegion paletteIcon) {
        this.content.add(item);
    }

    @Deprecated
    public void addItem(ITEM item, TextureRegion paletteIcon, Color color) {
        this.content.add(item);
    }

    public void deselect() {
        if (this.buttonGroup != null) {
            this.buttonGroup.uncheckAll();
        }
    }

    public void clearItems() {
        this.content.clear();
        this.updateToContent();
    }

    public void setItems(Collection<ITEM> list) {
        this.content.clear();
        this.content.addAll(list);
        if (this.buttonGroup != null) {
            this.buttonGroup.uncheckAll();
        }
        this.updateToContent();
    }

    public void setItems(List<ITEM> list) {
        this.content.clear();
        this.content.addAll(list);
        if (this.buttonGroup != null) {
            this.buttonGroup.uncheckAll();
        }
        this.updateToContent();
    }

    public void updateButton(ITEM ofItem) {
        int contentIndex = this.content.indexOf(ofItem);
        int page = contentIndex / this.buttons.size() + 1;
        if (page == this.getCurrentPage()) {
            int buttonIndex = contentIndex - (this.defaultPaginator.getCurrentPage() - 1) * this.buttons.size();
            this.buttonUpdater.updateButton((Button)this.buttons.get(buttonIndex), ofItem);
        }
    }

    @Override
    public int getMaxPages() {
        return this.defaultPaginator.getMaxPages();
    }

    @Override
    public void setMaxPages(int maxPages) {
        throw new UnsupportedOperationException("This method is not supposed to be used. Use the Paginator within this component instead.");
    }

    @Override
    public void configure(int totalItems, int itemsPerPage) {
        throw new UnsupportedOperationException("This method is not supposed to be used. Use the Paginator within this component instead.");
    }

    @Override
    public void nextPage() {
        this.defaultPaginator.nextPage();
        this.updateToContent();
        if (this.buttonGroup != null) {
            this.buttonGroup.uncheckAll();
        }
    }

    @Override
    public void previousPage() {
        this.defaultPaginator.previousPage();
        this.updateToContent();
        if (this.buttonGroup != null) {
            this.buttonGroup.uncheckAll();
        }
    }

    public List<BUTTON> getButtons() {
        return this.buttons;
    }

    public PaletteListener<ITEM> getListener() {
        return this.listener;
    }

    public ITEM getSelected() {
        if (this.buttonGroup == null) {
            return null;
        }
        int itemIndex = this.buttonGroup.getCheckedIndex() + (this.defaultPaginator.getCurrentPage() - 1) * this.buttons.size();
        if (itemIndex < this.content.size() && itemIndex >= 0) {
            return this.content.get(itemIndex);
        }
        return null;
    }

    public int getSelectedIndex() {
        if (this.buttonGroup == null) {
            return -1;
        }
        int itemIndex = this.buttonGroup.getCheckedIndex() + (this.defaultPaginator.getCurrentPage() - 1) * this.buttons.size();
        if (itemIndex < this.content.size() && itemIndex >= 0) {
            return itemIndex;
        }
        return -1;
    }

    public static interface ButtonUpdater<B extends Button, ITEM> {
        public B createButton(ComponentFactory var1, String var2);

        public void updateButton(B var1, ITEM var2);

        public void resetButton(B var1);
    }

    public static interface PaletteListener<T> {
        public void onSelectedChanged(T var1);
    }

    public static class PaletteStyle {
        public String baseButtonStyle;
        public int iconCount = 24;
        public int columns = 5;
    }
}

