/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.actions;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.io.BlueprintLoader;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.ui.commons.widgets.dialog.DialogBox;
import com.neutronio.astrax.ui.editor.EditorComponent;

public class SaveAction
implements Runnable {
    private BlueprintLoader blueprintLoader = new BlueprintLoader();
    private SatelliteGrid toSave;
    private String path;
    private String filename;
    private EditorComponent editorComponent;

    public SaveAction(EditorComponent editorComponent) {
        this.editorComponent = editorComponent;
    }

    public void setToSave(SatelliteGrid spacecraft, String path, String filename) {
        this.toSave = spacecraft;
        this.path = path;
        this.filename = filename;
    }

    @Override
    public void run() {
        if (this.toSave == null || this.path == null || this.filename == null) {
            Message message = new Message(Message.MessageType.WARNING, "Please Use 'Save as...' first!");
            this.editorComponent.logAndShowMessage(message);
        } else {
            AstraXApp.astraX.showDialogBox(String.format("Are you sure you want to overwrite '%s'?", this.filename), new DialogBox.DialogBoxListener(){

                @Override
                public void onProceed() {
                    FileHandler.State state = SaveAction.this.blueprintLoader.save(SaveAction.this.toSave, SaveAction.this.path, SaveAction.this.filename, true);
                    Message message = new Message();
                    String translate = SaveAction.this.editorComponent.getComponentFactory().translate(state.message, SaveAction.this.filename);
                    message.setType(state.messageType);
                    message.setMessage(translate);
                    SaveAction.this.editorComponent.logAndShowMessage(message);
                }

                @Override
                public void onCancel() {
                }
            });
        }
    }
}

