/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.file;

import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.BlueprintLoader;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.editor.EditorComponent;
import com.neutronio.astrax.ui.files.FileDialogForm;
import java.io.IOException;
import java.util.logging.Logger;

public class EditorFileDialogCallback {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private BlueprintLoader blueprintLoader = new BlueprintLoader();
    private FileDialogForm fileDialog;
    private Modal<FileDialogForm> fileDialogModal;
    private EditorComponent editorComponent;

    public EditorFileDialogCallback(FileDialogForm fileDialog, Modal<FileDialogForm> fileDialogModal, EditorComponent editorComponent) {
        this.fileDialog = fileDialog;
        this.fileDialogModal = fileDialogModal;
        this.editorComponent = editorComponent;
    }

    public void onFileLoad(AstraXFiles.AstraXFile file) {
        this.logger.fine("Loading spacecraft into editor... ");
        try {
            SatelliteGrid loadedSpacecraft = this.blueprintLoader.load(file);
            this.editorComponent.saveAction.setToSave(loadedSpacecraft, file.path, file.file.getName());
            if (loadedSpacecraft == null) {
                this.editorComponent.logAndShowMessage(new Message(Message.MessageType.ALERT, "File could not be loaded"));
                return;
            }
            this.editorComponent.onLoadSpacecraft(loadedSpacecraft);
            this.fileDialogModal.hide();
            this.editorComponent.logAndShowMessage(new Message(Message.MessageType.SUCCESS, "Spacecraft loaded!"));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.editorComponent.logAndShowMessage(new Message(Message.MessageType.ALERT, "An error occurred! Please check log"));
        }
    }

    public void onFileSaved(SatelliteGrid satelliteGrid, String basePath, String filename) {
        FileHandler.State state = this.blueprintLoader.save(satelliteGrid, basePath, filename, false);
        Message message = new Message();
        String translate = this.editorComponent.getComponentFactory().translate(state.message, filename);
        message.setType(state.messageType);
        message.setMessage(translate);
        this.editorComponent.logAndShowMessage(message);
        this.editorComponent.saveAction.setToSave(satelliteGrid, basePath, filename);
        this.fileDialog.setOriginFolder(basePath);
        this.logger.fine(message.getMessage());
    }

    public void onFileDelete(AstraXFiles.AstraXFile file) {
        this.logger.fine("Deleting file... ");
        boolean deleted = this.blueprintLoader.getFileHandler().deleteFile(file);
        if (deleted) {
            this.editorComponent.logAndShowMessage(new Message(Message.MessageType.SUCCESS, "File Deleted!"));
        } else {
            this.editorComponent.logAndShowMessage(new Message(Message.MessageType.ALERT, "Could not delete file!"));
        }
        this.fileDialog.setOriginFolder("userdata/spacecraft");
    }

    public void onBack() {
        this.logger.fine("On Back... ");
        this.fileDialogModal.hide();
    }
}

