/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.file;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteRole;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.VesselSize;
import com.neutronio.astrax.editor.NewSatelliteSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.text.TextSelector;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.commons.widgets.TooltipContent;
import java.util.Objects;

public class NewSatellitePanel
extends AbstractForm {
    private TextArea fileNameValue;
    private TextField nameValue;
    private TextSelector<VesselSize> vesselSizeValue;
    private TextSelector<SatelliteRole> vesselRole;
    private TooltipContent roleTooltip;
    private TooltipContent vesselSizeTooltip;

    public NewSatellitePanel(ComponentFactory componentFactory) {
        super(componentFactory, "default", "tab-inner");
        this.roleTooltip = new TooltipContent(componentFactory.translate("spacecraft_editor_satellite_vesselRole_hint"), this.getSkin());
        this.roleTooltip.pack();
        this.vesselSizeTooltip = new TooltipContent(componentFactory.translate("spacecraft_editor_satellite_vesselRole_hint"), this.getSkin());
        this.vesselSizeTooltip.pack();
        this.nameValue = new TextField(componentFactory.translate("spacecraft_editor_satellite_name_placeholder"), componentFactory.getSkin());
        this.nameValue.removeListener(this.nameValue.getDefaultInputListener());
        this.nameValue.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                event.setBubbles(false);
            }
        });
        this.nameValue.addListener(this.nameValue.getDefaultInputListener());
        String stationRole = componentFactory.translate("spacecraft_editor_satellite_vesselRole_station");
        String capitalRole = componentFactory.translate("spacecraft_editor_satellite_vesselRole_capitalShip");
        String boatRole = componentFactory.translate("spacecraft_editor_satellite_vesselRole_lifeBoat");
        final String tinySize = componentFactory.translate("spacecraft_editor_satellite_vesselSize_tiny");
        final String smallSize = componentFactory.translate("spacecraft_editor_satellite_vesselSize_small");
        final String mediumSize = componentFactory.translate("spacecraft_editor_satellite_vesselSize_medium");
        final String largeSize = componentFactory.translate("spacecraft_editor_satellite_vesselSize_large");
        this.vesselRole = new TextSelector(componentFactory);
        this.vesselRole.addItem(new SelectBoxWrapper<SatelliteRole>(stationRole, SatelliteRole.STATION));
        this.vesselRole.addItem(new SelectBoxWrapper<SatelliteRole>(capitalRole, SatelliteRole.CAPITAL_SHIP));
        this.vesselRole.addItem(new SelectBoxWrapper<SatelliteRole>(boatRole, SatelliteRole.LIFEBOAT));
        this.vesselRole.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (NewSatellitePanel.this.vesselRole.getSelectedObject() != null) {
                    VesselSize oldSelection = (VesselSize)((Object)NewSatellitePanel.this.vesselSizeValue.getSelectedObject());
                    NewSatellitePanel.this.vesselSizeValue.clearItems();
                    switch ((SatelliteRole)((Object)NewSatellitePanel.this.vesselRole.getSelectedObject())) {
                        case LIFEBOAT: {
                            NewSatellitePanel.this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(tinySize, VesselSize.TINY));
                            NewSatellitePanel.this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(smallSize, VesselSize.SMALL));
                            NewSatellitePanel.this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(mediumSize, VesselSize.MEDIUM));
                            break;
                        }
                        case CAPITAL_SHIP: {
                            NewSatellitePanel.this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(mediumSize, VesselSize.MEDIUM));
                            NewSatellitePanel.this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(largeSize, VesselSize.LARGE));
                            break;
                        }
                        case STATION: {
                            NewSatellitePanel.this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(largeSize, VesselSize.LARGE));
                        }
                    }
                    NewSatellitePanel.this.vesselSizeValue.setSelected(oldSelection, false);
                    NewSatellitePanel.this.vesselSizeValue.pack();
                }
            }
        });
        this.vesselRole.addListener(new Tooltip<TooltipContent>(this.roleTooltip));
        this.vesselRole.pack();
        this.vesselSizeValue = new TextSelector(componentFactory);
        this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(smallSize, VesselSize.SMALL));
        this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(mediumSize, VesselSize.MEDIUM));
        this.vesselSizeValue.addItem(new SelectBoxWrapper<VesselSize>(largeSize, VesselSize.LARGE));
        this.vesselSizeValue.addListener(new Tooltip<TooltipContent>(this.vesselSizeTooltip));
        this.vesselSizeValue.pack();
    }

    public NewSatelliteSettings getNewSatelliteSettings() {
        NewSatelliteSettings settings = new NewSatelliteSettings();
        settings.name = this.nameValue.getText();
        settings.vesselSize = this.vesselSizeValue.getSelectedObject();
        settings.vesselRole = this.vesselRole.getSelectedObject();
        return settings;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.nameValue.setDisabled(true);
        } else {
            this.nameValue.setDisabled(false);
        }
    }

    @Override
    public void construct() {
        super.construct();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_name"), this.nameValue);
        this.row();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_vesselRole"), this.vesselRole);
        this.row();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_vesselSize"), this.vesselSizeValue);
        this.row();
        this.pack();
    }

    @Override
    public void resetValues() {
        this.nameValue.setText(this.componentFactory.translate("spacecraft_editor_satellite_name_placeholder"));
        this.vesselRole.deselect();
        this.vesselSizeValue.deselect();
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        if (Objects.equals(this.nameValue.getText(), this.componentFactory.translate("spacecraft_editor_satellite_name_placeholder"))) {
            result.addMessage("Name must be changed!", this.nameValue).status(Form.ValidationStatus.INVALID);
        }
        if (this.nameValue.getText().isEmpty()) {
            result.addMessage("Name can't be empty!", this.nameValue).status(Form.ValidationStatus.INVALID);
        }
        if (this.vesselRole.getSelectedObject() == null) {
            result.addMessage("Vessel Role can't be empty!", this.vesselRole).status(Form.ValidationStatus.INVALID);
        }
        if (this.vesselSizeValue.getSelectedObject() == null) {
            result.addMessage("Vessel Size can't be empty!", this.vesselSizeValue).status(Form.ValidationStatus.INVALID);
        }
        return result;
    }

    @Override
    public void resetForm() {
        this.resetStyles();
        this.resetValues();
    }
}

