/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.header;

import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.widgets.TooltipContent;
import com.neutronio.astrax.util.StandardFormats;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CheckListStatus
extends HorizontalGroup {
    public static final String TOOLTIP = "Displays what errors, alerts, warnings that could be identified.";
    private ComponentFactory componentFactory;
    private Map<Message.MessageType, IconLabel> iconLabels = new LinkedHashMap<Message.MessageType, IconLabel>();
    private Map<Message.MessageType, Integer> messagesPerType = null;
    private TooltipContent tooltipContent;

    public CheckListStatus(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.tooltipContent = new TooltipContent(TOOLTIP, componentFactory.getSkin());
        this.space(5.0f);
        IconLabel infoLabel = new IconLabel(componentFactory, "info-compact");
        infoLabel.setText("0");
        IconLabel successLabel = new IconLabel(componentFactory, "success-compact");
        successLabel.setText("0");
        IconLabel warningsLabel = new IconLabel(componentFactory, "warning-compact");
        warningsLabel.setText("0");
        IconLabel alertLabel = new IconLabel(componentFactory, "error-compact");
        alertLabel.setText("0");
        IconLabel exceptionLabel = new IconLabel(componentFactory, "error-compact");
        exceptionLabel.setText("0");
        this.addListener(new Tooltip<TooltipContent>(this.tooltipContent));
        this.iconLabels.put(Message.MessageType.SUCCESS, infoLabel);
        this.iconLabels.put(Message.MessageType.INFO, infoLabel);
        this.iconLabels.put(Message.MessageType.WARNING, warningsLabel);
        this.iconLabels.put(Message.MessageType.ALERT, alertLabel);
        this.iconLabels.put(Message.MessageType.EXCEPTION, exceptionLabel);
        this.pack();
    }

    public void update(List<Message> messages) {
        this.messagesPerType = this.countTypes(messages);
        for (Message.MessageType type : Message.MessageType.values()) {
            IconLabel label = this.iconLabels.get((Object)type);
            label.setText(StandardFormats.INTEGER.format(this.messagesPerType.get((Object)type)));
            if (this.messagesPerType.get((Object)type) == 0) {
                this.removeActor(label);
                continue;
            }
            this.addActor(label);
        }
        this.pack();
    }

    private Map<Message.MessageType, Integer> countTypes(List<Message> messages) {
        LinkedHashMap<Message.MessageType, Integer> result = new LinkedHashMap<Message.MessageType, Integer>();
        for (Message.MessageType type : Message.MessageType.values()) {
            result.put(type, 0);
        }
        for (Message message : messages) {
            result.put(message.getType(), (Integer)result.get((Object)message.getType()) + 1);
        }
        return result;
    }
}

