/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.overlays;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.editor.overlays.Overlay;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;

public class OverlayPicker
extends VerticalGroup {
    protected StaticIcon icon;
    protected SelectBox<SelectBoxWrapper<Overlay>> selectBox;
    protected Label label;
    private Array<SelectBoxWrapper<Overlay>> wrappers = new Array();

    public OverlayPicker(ComponentFactory componentFactory) {
        this.space(5.0f);
        this.label = new Label("Overlay", componentFactory.getSkin(), "small-no-bg");
        this.selectBox = new SelectBox(componentFactory.getSkin());
        this.addActor(this.label);
        this.addActor(this.selectBox);
        this.selectBox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                OverlayPicker.this.fire(changeEvent);
                Pools.free(changeEvent);
            }
        });
    }

    public SelectBoxWrapper<Overlay> getSelected() {
        return this.selectBox.getSelected();
    }

    public void clearChoices() {
        this.wrappers.clear();
    }

    public void addOverlay(String name, Overlay overlay) {
        this.wrappers.add(new SelectBoxWrapper<Overlay>(name, overlay));
    }

    public void update() {
        this.selectBox.setItems(this.wrappers);
    }
}

