/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.tab.Tab;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.SatelliteInfoPanel;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.SatelliteInfoTabs;

public class SatelliteStatisticsTabs
extends Tab {
    private SatelliteInfoTabs satelliteInfoTabs;
    private SatelliteInfoPanel satelliteInfoEditorPanel;

    public SatelliteStatisticsTabs(ComponentFactory componentFactory) {
        super(componentFactory, "window", "window-body");
        this.satelliteInfoEditorPanel = new SatelliteInfoPanel(componentFactory);
        this.satelliteInfoEditorPanel.construct();
        this.satelliteInfoEditorPanel.align(2);
        this.satelliteInfoTabs = new SatelliteInfoTabs(componentFactory);
        this.satelliteInfoTabs.construct();
        Table satelliteInfoGroup = new Table();
        TextArea textArea = new TextArea(componentFactory.translate("spacecraft_editor_satellite_performance_hint"), componentFactory.getSkin(), "editor");
        textArea.setDisabled(true);
        textArea.setPrefRows(2.0f);
        satelliteInfoGroup.add(textArea).padBottom(10.0f).fill();
        satelliteInfoGroup.row();
        satelliteInfoGroup.add(this.satelliteInfoTabs);
        this.addTab(componentFactory.translate("spacecraft_editor_satellite_overview"), this.satelliteInfoEditorPanel);
        this.addTab(componentFactory.translate("spacecraft_editor_satellite_performance"), satelliteInfoGroup);
        this.construct();
    }

    public void update(SatelliteGrid satelliteGrid) {
        if (satelliteGrid == null) {
            this.satelliteInfoEditorPanel.resetValues();
            this.satelliteInfoTabs.resetValues();
        } else {
            this.satelliteInfoTabs.update(satelliteGrid);
            this.satelliteInfoEditorPanel.update(satelliteGrid);
        }
    }

    public void resetValues() {
        this.satelliteInfoTabs.resetValues();
    }
}

