/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft.statistics;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.editor.checklist.SatelliteValidator;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.MessageLog;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;

public class CheckList
extends SimplePanel {
    private IconLabel summaryLabel;
    private MessageLog messageLog;
    private PaginatorComponent paginatorComponent;

    public CheckList(ComponentFactory componentFactory) {
        super(componentFactory, "default", "window-body");
        this.summaryLabel = new IconLabel(componentFactory, "success");
        this.summaryLabel.setText("");
        this.messageLog = new MessageLog(componentFactory, "tab-inner", 8);
        this.messageLog.construct();
        this.paginatorComponent = new PaginatorComponent(componentFactory);
        this.paginatorComponent.setPaginator(this.messageLog.getPaginator());
        this.paginatorComponent.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                CheckList.this.messageLog.update();
            }
        });
        this.paginatorComponent.pack();
        this.addValue(this.summaryLabel).fill().spaceBottom(10.0f);
        this.row();
        this.addValue(this.messageLog).fill().spaceBottom(10.0f);
        this.row();
        this.addValue(this.paginatorComponent);
    }

    public void update(SatelliteValidator validator) {
        this.summaryLabel.setStyle(this.getSkin().get(validator.getValidationState().toIconLabelStyle(), IconLabel.IconLabelStyle.class));
        this.summaryLabel.setText(validator.getSummary().getMessage());
        this.messageLog.clearMessages();
        this.messageLog.addMessages(validator.getMessages());
        this.messageLog.sortMessages();
        this.messageLog.update();
        this.paginatorComponent.update();
        this.pack();
    }
}

