/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft.statistics;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.modules.TankInfoPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class FlowSystemInfoPanel
extends SimplePanel {
    private Image resourceIcon = new Image();
    private SelectBox<SelectBoxWrapper<Flow>> resourceFlowType;
    private TankInfoPanel flowSystemInfo;

    public FlowSystemInfoPanel(ComponentFactory factory) {
        super(factory, "editor", "tab-inner");
        this.resourceIcon.setSize(24.0f, 24.0f);
        this.resourceFlowType = new SelectBox(factory.getSkin());
        this.resourceFlowType.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (FlowSystemInfoPanel.this.resourceFlowType.getSelected() != null) {
                    Resource resource = ((Flow)((SelectBoxWrapper)((FlowSystemInfoPanel)FlowSystemInfoPanel.this).resourceFlowType.getSelected()).getPayload()).resource;
                    FlowSystemInfoPanel.this.resourceIcon.setDrawable(FlowSystemInfoPanel.this.componentFactory.getSkin().getDrawable(resource.getIcon()));
                    FlowSystemInfoPanel.this.flowSystemInfo.update(resource, ((Flow)((SelectBoxWrapper)((FlowSystemInfoPanel)FlowSystemInfoPanel.this).resourceFlowType.getSelected()).getPayload()).tankSettings);
                } else {
                    FlowSystemInfoPanel.this.resourceIcon.setDrawable(null);
                    FlowSystemInfoPanel.this.flowSystemInfo.resetValues();
                }
            }
        });
        this.flowSystemInfo = new TankInfoPanel(factory);
        this.flowSystemInfo.construct();
        this.flowSystemInfo.pack();
    }

    public void update(Collection<TankSettings> tanks) {
        ArrayList<SelectBoxWrapper<Flow>> wrappers = new ArrayList<SelectBoxWrapper<Flow>>();
        for (TankSettings tank : tanks) {
            Resource resource = (Resource)AstraXApp.astraX.getRepository(ResourceRepository.class).find(tank.fuelType);
            wrappers.add(new SelectBoxWrapper<Flow>(resource.getName(), new Flow(tank, resource)));
        }
        this.resourceFlowType.setItems(wrappers.toArray(new SelectBoxWrapper[0]));
    }

    public void update(SatelliteGrid satelliteGrid) {
        ArrayList<SelectBoxWrapper<Flow>> wrappers = new ArrayList<SelectBoxWrapper<Flow>>();
        Set<String> tankTypes = satelliteGrid.getTankTypes();
        for (String resourceID : tankTypes) {
            Resource resource = (Resource)AstraXApp.astraX.getRepository(ResourceRepository.class).find(resourceID);
            wrappers.add(new SelectBoxWrapper<Flow>(resource.getName(), new Flow(satelliteGrid.tankSettings.get(resourceID), resource)));
        }
        this.resourceFlowType.setItems(wrappers.toArray(new SelectBoxWrapper[0]));
    }

    @Override
    public void construct() {
        super.construct();
        this.addValue(this.resourceIcon, 1);
        this.getCell(this.resourceIcon).size(32.0f, 32.0f).padRight(10.0f);
        this.addValue(this.resourceFlowType, 1);
        this.row();
        this.addValue(this.flowSystemInfo, 2);
        this.pack();
    }

    @Override
    public void resetValues() {
        super.resetValues();
        this.flowSystemInfo.resetValues();
    }

    private class Flow {
        TankSettings tankSettings;
        Resource resource;

        public Flow(TankSettings tankSettings, Resource resource) {
            this.tankSettings = tankSettings;
            this.resource = resource;
        }
    }
}

