/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft.statistics;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.util.StandardFormats;

public class SatelliteInfoPanel
extends SimplePanel {
    public static final String NAME = "satellite_name";
    public static final String HITPOINTS = "satellite_hullpoints";
    public static final String VESSEL_TYPE = "satellite_vesselSize";
    public static final String WEIGHT = "satellite_weight";
    public static final String CARGO_WEIGHT = "satellite_carriedCargo";
    public static final String VALUE = "satellite_value";
    private AstraXLabel nameValue;
    private TextProgressbar hitpointsValue;
    private IconLabel vesselValue;
    private IconLabel cargoWeightValue;
    private IconLabel weightValue;
    private IconLabel valueValue;

    public SatelliteInfoPanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.pad(20.0f);
        this.nameValue = this.getLabel("-");
        this.nameValue.setAlignment(16);
        this.hitpointsValue = new TextProgressbar(componentFactory);
        this.hitpointsValue.setFormat(StandardFormats.FLOAT_AS_INTEGER);
        this.hitpointsValue.setBaseValue(0.0f);
        this.hitpointsValue.setValue(0.0f);
        this.weightValue = new IconLabel(componentFactory, "editor");
        this.weightValue.set("icon_inline_weight", "-");
        this.weightValue.right();
        this.weightValue.setLabelAlign(16);
        this.cargoWeightValue = new IconLabel(componentFactory, "editor");
        this.cargoWeightValue.set("icon_inline_weight", "-");
        this.cargoWeightValue.right();
        this.cargoWeightValue.setLabelAlign(16);
        this.valueValue = new IconLabel(componentFactory, "editor");
        this.valueValue.set("icon_inline_coins", "-");
        this.valueValue.right();
        this.valueValue.setLabelAlign(16);
        this.vesselValue = new IconLabel(componentFactory, "editor");
        this.vesselValue.set("icon_vessel_medium", "-");
        this.vesselValue.right();
        this.vesselValue.setLabelAlign(16);
    }

    public String getSpaceCraftName() {
        return this.nameValue.getText().toString();
    }

    public void update(Satellite satellite) {
        this.update(satellite.getSatelliteGrid());
        this.hitpointsValue.setValue(satellite.getHpCurrent());
    }

    public void update(SatelliteGrid satelliteGrid) {
        this.nameValue.setText(satelliteGrid.name);
        this.hitpointsValue.setBaseValue(satelliteGrid.hullpoints);
        this.hitpointsValue.setValue(1.0f);
        this.vesselValue.set(satelliteGrid.vesselSize.getIcon(), satelliteGrid.vesselSize.name());
        this.cargoWeightValue.setText(StandardFormats.WEIGHT.format(Float.valueOf(satelliteGrid.cargoSettings.maxWeight)) + " t");
        this.weightValue.setText(StandardFormats.WEIGHT.format(Float.valueOf(satelliteGrid.weight)) + " t");
        this.valueValue.setText(StandardFormats.MONEY_ITEM.format(Float.valueOf(satelliteGrid.value)) + " ");
    }

    @Override
    public void resetValues() {
        super.resetValues();
        this.nameValue.setText("-");
        this.hitpointsValue.setBaseValue(0.0f);
        this.hitpointsValue.setValue(0.0f);
        this.weightValue.setText("-");
        this.valueValue.setText("-");
    }

    @Override
    public void construct() {
        super.construct();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_name"), this.nameValue, 1);
        this.row();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_hullpoints"), this.hitpointsValue, 1);
        this.getCell(this.hitpointsValue).fill();
        this.row();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_vesselSize"), this.vesselValue, 1);
        this.getCell(this.vesselValue).fill();
        this.row();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_weight"), this.weightValue, 1);
        this.row();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_carriedCargo"), this.cargoWeightValue, 1);
        this.row();
        this.addRow(this.componentFactory.translate("spacecraft_editor_satellite_value"), this.valueValue, 1);
        this.pack();
    }
}

