/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft.statistics;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.ThrusterSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.tab.Tab;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.FlowSystemInfoPanel;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.modules.EngineInfoPanel;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.modules.QuartersInfoPanel;

public class SatelliteInfoTabs
extends Tab {
    private QuartersInfoPanel quartersInfoPanel;
    private FlowSystemInfoPanel tankInfoPanel;
    private EngineInfoPanel engineInfoPanel;

    public SatelliteInfoTabs(ComponentFactory factory) {
        super(factory, "tertiary-no-bg", null);
        this.quartersInfoPanel = new QuartersInfoPanel(factory);
        this.quartersInfoPanel.construct();
        this.quartersInfoPanel.pack();
        this.tankInfoPanel = new FlowSystemInfoPanel(factory);
        this.tankInfoPanel.construct();
        this.tankInfoPanel.pack();
        this.engineInfoPanel = new EngineInfoPanel(factory);
        this.engineInfoPanel.construct();
        this.engineInfoPanel.pack();
        this.addTab(this.componentFactory.translate("spacecraft_editor_satellite_quarters"), this.quartersInfoPanel);
        this.addTab(this.componentFactory.translate("spacecraft_editor_satellite_tanks"), this.tankInfoPanel);
        this.addTab(this.componentFactory.translate("spacecraft_editor_satellite_thrusters"), this.engineInfoPanel);
    }

    public void update(SatelliteGrid satelliteGrid) {
        this.quartersInfoPanel.update(satelliteGrid.quarterSettings);
        this.tankInfoPanel.update(satelliteGrid);
        ThrusterSettings thrusterSettings = satelliteGrid.thrusterSettings.get("resource_rocketFuel");
        if (thrusterSettings != null) {
            this.engineInfoPanel.update(thrusterSettings);
            this.engineInfoPanel.update(thrusterSettings.maxThrust / (satelliteGrid.weight * 1000.0f));
        }
    }

    public void resetValues() {
        this.quartersInfoPanel.resetValues();
        this.engineInfoPanel.resetValues();
        this.tankInfoPanel.resetValues();
    }
}

