/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft.statistics.modules;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.ThrusterSettings;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.util.StandardFormats;
import java.util.ArrayList;
import java.util.List;

public class EngineInfoPanel
extends SimplePanel {
    public static final String EMPTY_PANEL_HINT = "Hint: Stations do not have engines, so this panel can be empty.";
    public static final String FUEL_TYPE = "Fuel Type";
    public static final String FUEL_CONSUMPTION = "Consumption";
    public static final String MAX_THRUST = "Thrust";
    public static final String THRUST_WEIGHT_RATIO = "Ratio";
    public static final String UNIT_KN = "kN";
    public static final String UNIT_LITERS_PER_SECOND = "l/s";
    private TextArea hintArea;
    private List<AstraXLabel> unitLabels = new ArrayList<AstraXLabel>();
    private Image resourceIcon;
    private AstraXLabel resourceValue;
    private AstraXLabel fuelConsumptionValue;
    private AstraXLabel maxThrustValue;
    private AstraXLabel thrustToWeightValue;

    public EngineInfoPanel(ComponentFactory componentFactory) {
        super(componentFactory, "editor", "tab-inner");
        this.hintArea = new TextArea(EMPTY_PANEL_HINT, componentFactory.getSkin());
        this.hintArea.setPrefRows(3.0f);
        this.hintArea.setDisabled(true);
        this.resourceIcon = new Image();
        this.resourceIcon.setSize(24.0f, 24.0f);
        this.resourceValue = this.getLabel("-");
        this.resourceValue.setAlignment(16);
        this.fuelConsumptionValue = this.getLabel("-");
        this.fuelConsumptionValue.setAlignment(16);
        this.maxThrustValue = this.getLabel("-");
        this.maxThrustValue.setAlignment(16);
        this.thrustToWeightValue = this.getLabel("-");
        this.thrustToWeightValue.setAlignment(16);
    }

    public void update(float thrustToWeight) {
        this.thrustToWeightValue.setText(StandardFormats.FACTOR.format(Float.valueOf(thrustToWeight)));
    }

    public void update(ThrusterSettings thrusterSettings) {
        Resource resource = (Resource)AstraXApp.astraX.getRepository(ResourceRepository.class).find(thrusterSettings.fuelType);
        if (resource != null) {
            this.resourceIcon.setDrawable(this.componentFactory.getSkin().getDrawable(resource.getIcon()));
            this.resourceValue.setText(resource.getName());
        }
        this.fuelConsumptionValue.setText(StandardFormats.FLOAT_COUNT.format(Float.valueOf(thrusterSettings.fuelConsumption)));
        this.maxThrustValue.setText(StandardFormats.PERCENT.format(Float.valueOf(thrusterSettings.maxThrust)) + " " + UNIT_KN);
    }

    private AstraXLabel addUnitLabel(String labelText) {
        AstraXLabel label = new AstraXLabel(this.componentFactory, labelText, "default-no-bg", "label");
        label.setAlignment(8, 8);
        this.add(label).left().width(48.0f).padLeft(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding).fill();
        return label;
    }

    @Override
    public void resetValues() {
        super.resetValues();
        this.resourceValue.setText("-");
        this.fuelConsumptionValue.setText("-");
        this.maxThrustValue.setText("-");
        this.thrustToWeightValue.setText("-");
    }

    @Override
    public void construct() {
        super.construct();
        this.addLabel(FUEL_TYPE, 1);
        this.addValue(this.resourceValue, 1);
        this.addValueCentered(this.resourceIcon, 1);
        this.row();
        this.addRow(FUEL_CONSUMPTION, this.fuelConsumptionValue);
        this.unitLabels.add(this.addUnitLabel(UNIT_LITERS_PER_SECOND));
        this.row();
        this.addRow(MAX_THRUST, this.maxThrustValue);
        this.unitLabels.add(this.addUnitLabel(UNIT_KN));
        this.row();
        this.addRow(THRUST_WEIGHT_RATIO, this.thrustToWeightValue);
        this.unitLabels.add(this.addUnitLabel(""));
        this.row();
        this.addValue(this.hintArea, 3);
        this.getCell(this.hintArea).padTop(20.0f);
    }
}

