/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft.statistics.modules;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.quarters.QuarterSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.RatingComponent;
import com.neutronio.astrax.util.StandardFormats;

public class QuartersInfoPanel
extends SimplePanel {
    public static final String BEDS = "Beds";
    public static final String COMFORT = "Comfort";
    private Label bedsLabel;
    RatingComponent comfortRatingValue;

    public QuartersInfoPanel(ComponentFactory componentFactory) {
        super(componentFactory, "editor", "tab-inner");
        this.bedsLabel = new Label((CharSequence)"-", this.panelStyle.labelStyle);
        this.comfortRatingValue = new RatingComponent(componentFactory.getSkin(), "beds", 5);
    }

    @Override
    public void resetValues() {
        super.resetValues();
        this.bedsLabel.setText("-");
        this.comfortRatingValue.setRating(0);
    }

    public void update(QuarterSettings settings) {
        this.bedsLabel.setText(StandardFormats.INTEGER.format(settings.beds));
        this.comfortRatingValue.setRating((int)MathUtils.clamp(settings.comfort / (float)settings.beds * 5.0f, 0.0f, 5.0f));
    }

    @Override
    public void construct() {
        this.clearChildren();
        super.construct();
        this.addRow(BEDS, this.bedsLabel);
        this.row();
        this.addRow(COMFORT, this.comfortRatingValue);
    }
}

