/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.spacecraft.statistics.modules;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.util.StandardFormats;
import com.neutronio.astrax.util.date.Timespan;
import java.util.ArrayList;
import java.util.List;

public class TankInfoPanel
extends SimplePanel {
    public static final String STORED = "Capacity";
    public static final String PRODUCED = "Produced";
    public static final String CONSUMED = "Consumed";
    public static final String NET = "Net";
    public static final String TIME_UNTIL_EMPTY = "Time until empty";
    private String unit = "kwH";
    private List<Label> unitLabels = new ArrayList<Label>();
    private AstraXLabel produceLabel = this.getLabel("-");
    private AstraXLabel consumptionLabel;
    private AstraXLabel netLabel;
    private AstraXLabel capacityLabel;
    private AstraXLabel timeEmptyLabel;

    public TankInfoPanel(ComponentFactory componentFactory) {
        super(componentFactory, "editor", null);
        this.produceLabel.setAlignment(16);
        this.consumptionLabel = this.getLabel("-");
        this.consumptionLabel.setAlignment(16);
        this.netLabel = this.getLabel("-");
        this.netLabel.setAlignment(16);
        this.capacityLabel = this.getLabel("-");
        this.capacityLabel.setAlignment(16);
        this.timeEmptyLabel = this.getLabel("-");
        this.timeEmptyLabel.setAlignment(16);
    }

    @Override
    public void resetValues() {
        this.capacityLabel.setText("-");
        this.consumptionLabel.setText("-");
        this.produceLabel.setText("-");
        this.netLabel.setText("-");
        this.netLabel.setColor(Color.WHITE);
        this.timeEmptyLabel.setText("-");
        for (Label label : this.unitLabels) {
            label.setText("");
            label.setAlignment(8, 8);
        }
    }

    private Label addUnitLabel(String labelText) {
        Label label = new Label(labelText, this.getSkin(), "transparent");
        label.setAlignment(8, 8);
        this.add(label).left().width(48.0f).padLeft(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding).fill();
        return label;
    }

    @Override
    public void construct() {
        super.construct();
        this.addRow(STORED, this.capacityLabel);
        this.unitLabels.add(this.addUnitLabel(""));
        this.row();
        this.addSeparator(8.0f, 200.0f, 3);
        this.row();
        this.addRow(PRODUCED, this.produceLabel);
        this.unitLabels.add(this.addUnitLabel(""));
        this.row();
        this.addRow(CONSUMED, this.consumptionLabel);
        this.unitLabels.add(this.addUnitLabel(""));
        this.row();
        this.addSeparator(8.0f, 200.0f, 3);
        this.row();
        this.addRow(NET, this.netLabel);
        this.unitLabels.add(this.addUnitLabel(""));
        this.row();
        this.addRow(TIME_UNTIL_EMPTY, this.timeEmptyLabel);
        this.addUnitLabel("d");
        this.row();
    }

    public void update(Resource resource, TankSettings tankSettings) {
        if (tankSettings != null) {
            float netProduction = tankSettings.production - tankSettings.consumption;
            this.capacityLabel.setText(StandardFormats.FLOAT_COUNT.format(Float.valueOf(tankSettings.capacity)));
            this.consumptionLabel.setText(StandardFormats.FLOAT_COUNT.format(Float.valueOf(tankSettings.consumption)));
            this.produceLabel.setText(StandardFormats.FLOAT_COUNT.format(Float.valueOf(tankSettings.production)));
            String symbol = "+";
            if (netProduction < 0.0f) {
                symbol = "-";
                this.netLabel.setColor(Color.RED);
                long seconds = (long)(tankSettings.capacity / Math.abs(netProduction));
                this.timeEmptyLabel.setText(Timespan.convertSecondsTo_ddhhmmss(seconds));
            } else {
                this.netLabel.setColor(Color.YELLOW);
                this.timeEmptyLabel.setText("n.a.");
            }
            this.netLabel.setText(symbol + StandardFormats.FLOAT_COUNT.format(Float.valueOf(netProduction)));
            this.unit = resource.getUnit();
            for (Label label : this.unitLabels) {
                label.setText(this.unit);
                label.setAlignment(8, 8);
            }
        } else {
            this.resetValues();
        }
    }
}

