/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.editor.EditorGrid;
import com.neutronio.astrax.util.Vector2i;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class CanvasTile
extends ClickListener {
    protected EditorGrid parent;
    public Vector2i location = new Vector2i(0, 0);
    public Color color = Color.WHITE;
    public boolean canPaint;
    public boolean hidden = false;
    public boolean active = false;

    public CanvasTile(EditorGrid editorGrid) {
        this.parent = editorGrid;
    }

    public EditorGrid getParent() {
        return this.parent;
    }

    public void render(Batch batch, ShapeDrawer shapeDrawer, float x, float y, float scaleX, float scaleY, float time) {
        if (this.hidden || !this.active) {
            return;
        }
        float guideAlpha = Interpolation.sine.apply(time * 0.7f);
        shapeDrawer.setColor(this.color.r, this.color.g, this.color.b, guideAlpha);
        shapeDrawer.setDefaultLineWidth(3.0f);
        shapeDrawer.rectangle(x + (float)(this.location.x * 16) * scaleX, y + (float)(this.location.y * 16) * scaleY, 16.0f * scaleX, 16.0f * scaleY);
    }

    public void setParent(EditorGrid parent) {
        this.parent = parent;
    }

    @Override
    public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
        super.enter(event, x, y, pointer, fromActor);
        if (!this.active) {
            return;
        }
        if (this.isOver()) {
            this.hidden = false;
        }
    }

    @Override
    public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
        super.exit(event, x, y, pointer, toActor);
        if (!this.active) {
            return;
        }
        if (!this.isOver()) {
            this.hidden = true;
        }
    }

    @Override
    public boolean mouseMoved(InputEvent event, float x, float y) {
        if (!this.active) {
            return false;
        }
        this.location.x = (int)x / 16;
        this.location.y = (int)y / 16;
        return super.mouseMoved(event, x, y);
    }
}

