/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.neutronio.astrax.editor.placement.Connector;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.editor.toolbox.SpacecraftCell;
import com.neutronio.astrax.ui.editor.EditorGrid;
import com.neutronio.astrax.ui.editor.tools.CanvasTile;
import java.util.List;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class EditCanvasTile
extends CanvasTile {
    public Connector connector = new Connector(false, false, false, false);
    public TextureRegion region = null;
    public Orientation orientation = Orientation.NORTH;
    public Color moduleColor = Color.WHITE;

    public EditCanvasTile(EditorGrid editorGrid) {
        super(editorGrid);
    }

    public void apply(SpacecraftCell spacecraftCell) {
        this.region = spacecraftCell.region;
        this.orientation = spacecraftCell.orientation;
        this.connector = spacecraftCell.connector.copy();
        this.moduleColor = spacecraftCell.color;
    }

    @Override
    public void render(Batch batch, ShapeDrawer shapeDrawer, float x, float y, float scaleX, float scaleY, float time) {
        if (this.hidden || !this.active) {
            return;
        }
        float tileLocationX = (float)(this.location.x * 16) * scaleX;
        float tileLocationY = (float)(this.location.y * 16) * scaleY;
        float guideAlpha = Interpolation.sine.apply(time * 0.7f);
        if (this.region != null) {
            batch.setColor(this.color.r, this.color.g, this.color.b, 0.5f);
            batch.draw(this.region, x + (float)(this.location.x * 16) * scaleX, y + (float)(this.location.y * 16) * scaleY, 16.0f * scaleX / 2.0f, 16.0f * scaleY / 2.0f, 16.0f * scaleX, 16.0f * scaleY, 1.0f, 1.0f, -this.orientation.getRotationDegrees());
        }
        shapeDrawer.setDefaultLineWidth(3.0f);
        shapeDrawer.setColor(this.color.r, this.color.g, this.color.b, guideAlpha * 0.5f);
        shapeDrawer.filledRectangle(x + (float)(this.location.x * 16) * scaleX, y + (float)(this.location.y * 16) * scaleY, 16.0f * scaleX, 16.0f * scaleY);
        shapeDrawer.setColor(this.color.r, this.color.g, this.color.b, guideAlpha);
        shapeDrawer.rectangle(x + (float)(this.location.x * 16) * scaleX, y + (float)(this.location.y * 16) * scaleY, 16.0f * scaleX, 16.0f * scaleY);
        if (!this.canPaint) {
            shapeDrawer.line(x + tileLocationX, y + tileLocationY, x + 16.0f * scaleX + tileLocationX, y + 16.0f * scaleY + tileLocationY);
            shapeDrawer.line(x + tileLocationX + 16.0f * scaleX, y + tileLocationY, x + tileLocationX, y + 16.0f * scaleY + tileLocationY);
        }
        if (this.connector != null) {
            this.parent.drawConnector(shapeDrawer, this.connector, tileLocationX, tileLocationY, this.parent.getConnectorRadius());
        }
    }

    @Override
    public boolean mouseMoved(InputEvent event, float x, float y) {
        if (!this.active) {
            return false;
        }
        boolean moved = super.mouseMoved(event, x, y);
        List<EditorGrid.AdjacentTile> adjacentTiles = this.parent.findAdjacentTiles(this.location.x, this.location.y);
        this.canPaint = this.parent.isFirstBlock();
        for (EditorGrid.AdjacentTile adjacentCell : adjacentTiles) {
            this.canPaint = this.canPaint || this.parent.placementValidator.canPlace(this.connector, adjacentCell.cell.connector, adjacentCell.orientation);
        }
        this.canPaint = this.canPaint && this.parent.getData().get((int)this.location.x, (int)this.location.y).module == null;
        this.color = this.canPaint ? this.moduleColor : Color.RED;
        return moved;
    }
}

