/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.Checkbox;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.ui.editor.ButtonPalette;
import com.neutronio.astrax.ui.editor.ModulePalette;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.editor.tools.ModulePanel;

public class EditToolPanel
extends SimplePanel {
    private Checkbox eraserCheckBox;
    private ModulePalette modulePalette;
    private ButtonPalette<Orientation> orientation;
    private PaginatorComponent paginatorComponent;
    private ModulePanel modulePanel;
    private AstraXLabel moduleNameValue;
    private PaintToolSettingsListener listener;

    public EditToolPanel(ComponentFactory factory) {
        super(factory, "editor-sidebar", "outset");
        this.modulePanel = new ModulePanel(this.componentFactory);
        this.modulePanel.construct();
        this.modulePalette = new ModulePalette(this.componentFactory);
        this.orientation = new ButtonPalette(this.componentFactory);
        this.orientation.setPrefIconSize(24);
        this.orientation.setIconCount(4);
        this.orientation.addItem(Orientation.NORTH);
        this.orientation.addItem(Orientation.EAST);
        this.orientation.addItem(Orientation.SOUTH);
        this.orientation.addItem(Orientation.WEST);
        this.orientation.setButtonProducer(new Palette.ButtonUpdater<AstraXButton, Orientation>(){

            @Override
            public AstraXButton createButton(ComponentFactory componentFactory, String style) {
                return new AstraXButton(componentFactory, style);
            }

            @Override
            public void updateButton(AstraXButton button, Orientation item) {
                button.setUserObject((Object)item);
                switch (item) {
                    case NORTH: {
                        button.setInlineIcon(EditToolPanel.this.componentFactory.getSkin().getDrawable("icon_inline_arrow_up"));
                        break;
                    }
                    case EAST: {
                        button.setInlineIcon(EditToolPanel.this.componentFactory.getSkin().getDrawable("icon_inline_arrow_right"));
                        break;
                    }
                    case SOUTH: {
                        button.setInlineIcon(EditToolPanel.this.componentFactory.getSkin().getDrawable("icon_inline_arrow_down"));
                        break;
                    }
                    case WEST: {
                        button.setInlineIcon(EditToolPanel.this.componentFactory.getSkin().getDrawable("icon_inline_arrow_left"));
                    }
                }
            }

            @Override
            public void resetButton(AstraXButton button) {
                button.setInlineIcon(null);
                button.setUserObject(null);
            }
        });
        this.orientation.fillWithButtons("editor-palette");
        this.orientation.updateToContent();
        this.orientation.pack();
        this.orientation.setListener(new Palette.PaletteListener<Orientation>(){

            @Override
            public void onSelectedChanged(Orientation selectedItem) {
                EditToolPanel.this.getListener().onOrientationChanged(selectedItem);
            }
        });
        this.paginatorComponent = new PaginatorComponent(this.componentFactory);
        this.paginatorComponent.setPaginator(this.modulePalette.getPalette());
        this.eraserCheckBox = new Checkbox(this.componentFactory, "checkbox");
        this.eraserCheckBox.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (EditToolPanel.this.eraserCheckBox.isChecked()) {
                    AstraXApp.astraX.getReactiveCursor().setActiveCursor("erase");
                } else {
                    AstraXApp.astraX.getReactiveCursor().setActiveCursor("edit");
                }
                EditToolPanel.this.getListener().onEraserChecked(EditToolPanel.this.eraserCheckBox.isChecked());
            }
        });
    }

    public void setEraserCheckBoxState(boolean checked) {
        this.eraserCheckBox.setChecked(checked);
    }

    public ModulePalette getModulePalette() {
        return this.modulePalette;
    }

    public Orientation getSelectedOrientation() {
        return (Orientation)((Object)this.orientation.getSelected());
    }

    public PaintToolSettingsListener getListener() {
        return this.listener;
    }

    public void setListener(PaintToolSettingsListener listener) {
        this.listener = listener;
    }

    public ModulePanel getModuleCompactInfoPanel() {
        return this.modulePanel;
    }

    public void setModuleName(String moduleName) {
        this.moduleNameValue.setText(moduleName);
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.addHeader("Edit", 2);
        this.row();
        this.addLabel("Eraser");
        this.add(this.eraserCheckBox).center().padBottom(this.panelStyle.rowPadding);
        this.row();
        this.addLabel("Orientation");
        this.addValue(this.orientation, 1);
        this.getCell(this.orientation).padBottom(20.0f);
        this.row();
        this.addHeader2("Modules", 2);
        this.row();
        this.moduleNameValue = this.getLabel("-");
        this.moduleNameValue.setAlignment(1, 1);
        this.addValueCentered(this.moduleNameValue, 2);
        this.row();
        this.addValue(this.modulePalette, 2);
        this.row();
        this.addValue(this.paginatorComponent, 2);
        this.getCell(this.paginatorComponent).padTop(20.0f).padBottom(20.0f);
    }

    public static interface PaintToolSettingsListener {
        public void onEraserChecked(boolean var1);

        public void onOrientationChanged(Orientation var1);
    }
}

