/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.editor.Editor;
import com.neutronio.astrax.editor.overlays.GradientOverlay;
import com.neutronio.astrax.editor.overlays.Overlay;
import com.neutronio.astrax.editor.toolbox.EditTool;
import com.neutronio.astrax.editor.toolbox.EditorToolBase;
import com.neutronio.astrax.editor.toolbox.InspectionTool;
import com.neutronio.astrax.editor.toolbox.PaintTool;
import com.neutronio.astrax.editor.toolbox.SelectionTool;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.ZoomButtons;
import com.neutronio.astrax.ui.editor.ButtonPalette;
import com.neutronio.astrax.ui.editor.EditorComponent;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.editor.overlays.GradientLegend;
import com.neutronio.astrax.ui.editor.overlays.OverlayPicker;
import java.util.Map;

public class EditorToolbar
extends Table {
    private ComponentFactory factory;
    private ButtonPalette<EditorToolBase> editorTools;
    private ZoomButtons zoomButtons;
    private EditorComponent editorComponent;
    private OverlayPicker overlayPicker;
    private GradientLegend gradientLegend;
    private TextButton rotateLeftKey;
    private TextButton rotateRightKey;
    private TextButton eraseKey;
    private SimplePanel keyHints;
    EditorToolbarListener listener;

    public EditorToolbar(ComponentFactory componentFactory, Editor editor, EditorComponent editorComponent) {
        this.factory = componentFactory;
        this.editorComponent = editorComponent;
        this.gradientLegend = new GradientLegend(componentFactory);
        this.gradientLegend.setVisible(false);
        this.overlayPicker = new OverlayPicker(componentFactory);
        this.overlayPicker.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EditorToolbar.this.gradientLegend.setVisible(EditorToolbar.this.overlayPicker.getSelected().getPayload() != null);
                if (EditorToolbar.this.overlayPicker.getSelected().getPayload() instanceof GradientOverlay) {
                    GradientOverlay gradientOverlay = (GradientOverlay)EditorToolbar.this.overlayPicker.getSelected().getPayload();
                    EditorToolbar.this.gradientLegend.setColorLegend(EditorToolbar.this.factory.getSkin().getRegion("background_outset_icon"), gradientOverlay.getGradient(5));
                }
                if (EditorToolbar.this.listener != null) {
                    EditorToolbar.this.listener.onOverlayChanged(EditorToolbar.this.overlayPicker.getSelected().toString(), EditorToolbar.this.overlayPicker.getSelected().getPayload());
                }
            }
        });
        this.editorTools = new ButtonPalette(componentFactory);
        this.editorTools.setButtonProducer(new Palette.ButtonUpdater<AstraXButton, EditorToolBase>(){

            @Override
            public AstraXButton createButton(ComponentFactory componentFactory, String style) {
                return new AstraXButton(componentFactory, style);
            }

            @Override
            public void updateButton(AstraXButton button, EditorToolBase item) {
                button.setUserObject(item);
                button.setInlineIcon(new TextureRegionDrawable(AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class).getSkin().getRegion(item.icon)));
            }

            @Override
            public void resetButton(AstraXButton button) {
                button.setUserObject(null);
                button.setInlineIcon(null);
            }
        });
        this.editorTools.setPrefIconSize(48);
        this.editorTools.setIconCount(4);
        this.editorTools.addItem(editor.getToolByClass(EditTool.class), componentFactory.getSkin().getRegion(editor.getToolByClass(EditTool.class).icon));
        this.editorTools.addItem(editor.getToolByClass(PaintTool.class), componentFactory.getSkin().getRegion(editor.getToolByClass(PaintTool.class).icon));
        this.editorTools.addItem(editor.getToolByClass(SelectionTool.class), componentFactory.getSkin().getRegion(editor.getToolByClass(SelectionTool.class).icon));
        this.editorTools.addItem(editor.getToolByClass(InspectionTool.class), componentFactory.getSkin().getRegion(editor.getToolByClass(InspectionTool.class).icon));
        this.editorTools.fillWithButtons("editor-toolbar");
        this.editorTools.setSelectedIndex(0);
        this.editorTools.updateToContent();
        this.editorTools.pack();
        this.add(this.editorTools);
        this.zoomButtons = new ZoomButtons(componentFactory);
        this.zoomButtons.construct();
        this.zoomButtons.setZoomable(editorComponent.getEditorGrid());
        this.add(this.zoomButtons).padLeft(5.0f).center();
        this.add(this.overlayPicker).padLeft(5.0f).top();
        this.add(this.gradientLegend).padLeft(5.0f).top();
        KeyMappingSettings editorControls = AstraXApp.astraX.getCoreDataPack().getDataPackSettings().getKeyMapping("editorControls");
        String rotateLeft = KeyMappingSettings.resolveKeyMappingName(editorControls.getMapping("astrax:editor:blockRotateLeft"));
        String rotateRight = KeyMappingSettings.resolveKeyMappingName(editorControls.getMapping("astrax:editor:blockRotateRight"));
        String erase = KeyMappingSettings.resolveKeyMappingName(editorControls.getMapping("astrax:editor:blockErase"));
        this.rotateLeftKey = new TextButton(rotateLeft, componentFactory.getSkin(), "keyMapping");
        this.rotateLeftKey.setTouchable(Touchable.disabled);
        this.rotateRightKey = new TextButton(rotateRight, componentFactory.getSkin(), "keyMapping");
        this.rotateRightKey.setTouchable(Touchable.disabled);
        this.eraseKey = new TextButton(erase, componentFactory.getSkin(), "keyMapping");
        this.eraseKey.setTouchable(Touchable.disabled);
        this.keyHints = new SimplePanel(componentFactory, "keyHints", null);
        this.keyHints.addLabel("Rotate");
        this.keyHints.addValueCentered(this.rotateLeftKey, 1);
        this.keyHints.addValueCentered(this.rotateRightKey, 1);
        this.keyHints.getCell(this.rotateRightKey).padRight(50.0f);
        this.keyHints.addLabel("Erase");
        this.keyHints.addValueCentered(this.eraseKey, 1);
        this.keyHints.pack();
        this.add(this.keyHints).padLeft(10.0f);
    }

    public void setListener(EditorToolbarListener listener) {
        this.listener = listener;
    }

    public void updateOverlayPicker(Map<String, Overlay> overlays) {
        this.overlayPicker.clearChoices();
        for (Map.Entry<String, Overlay> entries : overlays.entrySet()) {
            this.overlayPicker.addOverlay(entries.getKey(), entries.getValue());
        }
        this.overlayPicker.update();
    }

    public Palette<AstraXButton, EditorToolBase> getEditorTools() {
        return this.editorTools;
    }

    public ZoomButtons getZoomButtons() {
        return this.zoomButtons;
    }

    public static interface EditorToolbarListener {
        public void onOverlayChanged(String var1, Overlay var2);
    }
}

