/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.tab.Tab;
import com.neutronio.astrax.ui.editor.spacecraft.statistics.FlowSystemInfoPanel;
import com.neutronio.astrax.ui.editor.tools.ModulePanel;
import java.util.ArrayList;

public class ModuleDetailPanel
extends Tab {
    private ModulePanel modulePanel;
    private FlowSystemInfoPanel flowSystemInfoPanel;

    public ModuleDetailPanel(ComponentFactory factory) {
        super(factory, "default", null);
        this.modulePanel = new ModulePanel(factory);
        this.modulePanel.construct();
        this.modulePanel.align(2);
        VerticalGroup flowGroup = new VerticalGroup();
        flowGroup.space(15.0f);
        Label flowHint = new Label("Module Production/Consumption.\nCan be empty.", this.componentFactory.getSkin(), "small-no-bg");
        this.flowSystemInfoPanel = new FlowSystemInfoPanel(factory);
        this.flowSystemInfoPanel.construct();
        flowGroup.addActor(flowHint);
        flowGroup.addActor(this.flowSystemInfoPanel);
        flowGroup.align(2);
        this.addTab("Overview", this.modulePanel);
        this.addTab("Module I/O", flowGroup);
    }

    public void update(ModuleSettings moduleSettings) {
        ArrayList<TankSettings> tanks = new ArrayList<TankSettings>();
        this.modulePanel.update(moduleSettings);
        if (moduleSettings != null) {
            if (moduleSettings.tankSettings != null) {
                tanks.add(moduleSettings.tankSettings);
            }
            if (moduleSettings.energySettings != null) {
                tanks.add(moduleSettings.energySettings);
            }
            this.flowSystemInfoPanel.update(tanks);
        } else {
            this.flowSystemInfoPanel.resetValues();
        }
    }
}

