/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.util.StandardFormats;

public class ModulePanel
extends SimplePanel {
    private Label nameValue;
    private TextArea descriptionValue;
    private HorizontalGroup iconGroup;
    private IconLabel weightValue;
    private IconLabel valueValue;

    public ModulePanel(ComponentFactory componentFactory) {
        super(componentFactory, "editor", "tab-inner");
        this.nameValue = new Label("-", componentFactory.getSkin(), "default-no-bg");
        this.iconGroup = new HorizontalGroup();
        this.iconGroup.center();
        this.iconGroup.pad(6.0f, 3.0f, 6.0f, 3.0f);
        this.descriptionValue = new TextArea("", componentFactory.getSkin(), "editor");
        this.descriptionValue.setDisabled(true);
        this.descriptionValue.setPrefRows(3.0f);
        this.weightValue = new IconLabel(componentFactory, "editor");
        this.weightValue.set("icon_inline_weight", "0.0");
        this.valueValue = new IconLabel(componentFactory, "editor");
        this.valueValue.set("icon_inline_coins", "0.0");
    }

    @Override
    public void resetValues() {
        super.resetValues();
        this.nameValue.setText("-");
        this.descriptionValue.setText("-");
        this.weightValue.setText("-");
        this.valueValue.setText("-");
    }

    @Override
    public void construct() {
        super.construct();
        this.addValue(this.nameValue, 1);
        this.addValue(this.iconGroup, 1);
        this.getCell(this.iconGroup).minHeight(32.0f);
        this.row();
        this.addValue(this.descriptionValue, 2);
        this.row();
        this.addValue(this.weightValue, 1);
        this.addValue(this.valueValue, 1);
        this.row();
    }

    public void update(ModuleSettings module) {
        if (module == null) {
            this.resetValues();
            return;
        }
        this.iconGroup.clearChildren();
        if (module.marketSettings != null) {
            this.iconGroup.addActor(new Image(this.componentFactory.getSkin(), "icon_function_trade"));
        }
        if (module.cockpitSettings != null) {
            this.iconGroup.addActor(new Image(this.componentFactory.getSkin(), "icon_function_cockpit"));
        }
        if (module.cargoSettings != null) {
            this.iconGroup.addActor(new Image(this.componentFactory.getSkin(), "icon_function_cargo"));
        }
        if (module.dockerSettings != null) {
            this.iconGroup.addActor(new Image(this.componentFactory.getSkin(), "icon_function_docking"));
        }
        if (module.drillSettings != null) {
            this.iconGroup.addActor(new Image(this.componentFactory.getSkin(), "icon_function_mining"));
        }
        if (module.thrusterSettings != null) {
            this.iconGroup.addActor(new Image(this.componentFactory.getSkin(), "icon_function_thruster"));
        }
        if (module.quarterSettings != null) {
            this.iconGroup.addActor(new Image(this.componentFactory.getSkin(), "icon_function_quarters"));
        }
        if (module.tankSettings != null) {
            this.iconGroup.addActor(this.getTankIcon(module.tankSettings));
        }
        if (module.energySettings != null) {
            this.iconGroup.addActor(this.getTankIcon(module.energySettings));
        }
        this.nameValue.setText(module.name);
        this.descriptionValue.setText(module.description);
        this.weightValue.setText(StandardFormats.WEIGHT.format(module.weight + " t", new Object[0]));
        this.valueValue.setText(StandardFormats.MONEY_ITEM.format(Float.valueOf(module.value)));
    }

    private Image getTankIcon(TankSettings tankSettings) {
        Resource resource = (Resource)AstraXApp.astraX.findResource(tankSettings.fuelType);
        return new Image(this.componentFactory.getSkin(), resource.getIcon());
    }
}

