/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.ColorPaletteEditor;
import java.util.Map;
import java.util.logging.Logger;

public class PaintToolPanel
extends SimplePanel {
    private static Logger logger = Logger.getLogger(PaintToolPanel.class.getSimpleName());
    private AstraXTextButton paintSelectedButton;
    private AstraXTextButton resetSelectedButton;
    private ColorPaletteEditor colorPaletteEditor;
    private static Color[] DEFAULT_COLORS = new Color[]{Color.WHITE, Color.DARK_GRAY, Color.RED, Color.GREEN, Color.OLIVE, Color.CYAN, Color.BLUE, Color.BROWN, Color.YELLOW, Color.ORANGE, Color.VIOLET, Color.MAGENTA, Color.PINK, Color.PURPLE};
    private PaintToolPanelListener listener;

    public PaintToolPanel(ComponentFactory componentFactory) {
        super(componentFactory, "editor-sidebar", "outset");
        this.colorPaletteEditor = new ColorPaletteEditor(componentFactory);
        this.colorPaletteEditor.setColorPalette((Map)AstraXApp.astraX.getRepository(ColorRepository.class).find("palette-planet"));
        this.paintSelectedButton = new AstraXTextButton(componentFactory, "primary");
        this.paintSelectedButton.setCanCheck(false);
        this.paintSelectedButton.setText("Paint Selected");
        this.paintSelectedButton.addListener(componentFactory.getButtonSoundListener("default"));
        this.paintSelectedButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (PaintToolPanel.this.listener != null) {
                    PaintToolPanel.this.listener.onPaintSelected(PaintToolPanel.this.colorPaletteEditor.getSelectedColor());
                }
            }
        });
        this.resetSelectedButton = new AstraXTextButton(componentFactory, "primary");
        this.resetSelectedButton.setCanCheck(false);
        this.resetSelectedButton.setText("Reset Selected");
        this.resetSelectedButton.addListener(componentFactory.getButtonSoundListener("default"));
        this.resetSelectedButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (PaintToolPanel.this.listener != null) {
                    PaintToolPanel.this.listener.onResetSelected();
                }
            }
        });
    }

    @Override
    public void construct() {
        super.construct();
        this.addHeader("Paint", 2);
        this.row();
        HorizontalGroup buttonGroup = new HorizontalGroup();
        buttonGroup.space(10.0f);
        buttonGroup.align(1);
        buttonGroup.addActor(this.paintSelectedButton);
        buttonGroup.addActor(this.resetSelectedButton);
        this.addValue(buttonGroup);
        this.row();
        this.addValue(this.colorPaletteEditor);
    }

    public Color getSelectedColor() {
        return this.colorPaletteEditor.getSelectedColor();
    }

    public void setListener(PaintToolPanelListener listener) {
        this.listener = listener;
    }

    public static interface PaintToolPanelListener {
        public void onPaintSelected(Color var1);

        public void onResetSelected();

        public void onSelectedColorChanged(Color var1);
    }
}

