/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.tools;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;

public class SelectionToolPanel
extends SimplePanel {
    private AstraXTextButton inverseSelectionButton;
    private AstraXTextButton deselectButton;
    private AstraXTextButton selectModulesButton;
    private SelectionSettingsPanelListener selectionSettingsPanelListener;

    public SelectionToolPanel(ComponentFactory componentFactory) {
        super(componentFactory, "editor-sidebar", "outset");
        this.deselectButton = new AstraXTextButton(componentFactory, "primary");
        this.deselectButton.setText("Deselect");
        this.deselectButton.setCanCheck(false);
        this.deselectButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                SelectionToolPanel.this.selectionSettingsPanelListener.onDeselectAll();
            }
        });
        this.inverseSelectionButton = new AstraXTextButton(componentFactory, "primary");
        this.inverseSelectionButton.setText("Inverse");
        this.inverseSelectionButton.setCanCheck(false);
        this.inverseSelectionButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                SelectionToolPanel.this.selectionSettingsPanelListener.onInverseSelection();
            }
        });
        this.selectModulesButton = new AstraXTextButton(componentFactory, "primary");
        this.selectModulesButton.setText("Select Modules");
        this.selectModulesButton.setCanCheck(false);
        this.selectModulesButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                SelectionToolPanel.this.selectionSettingsPanelListener.onSelectBlocks();
            }
        });
    }

    public void setSelectionSettingsPanelListener(SelectionSettingsPanelListener selectionSettingsPanelListener) {
        this.selectionSettingsPanelListener = selectionSettingsPanelListener;
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.addHeader("Select", 2);
        this.row();
        this.addValueCentered(this.selectModulesButton, 2);
        this.row();
        this.addValue(this.deselectButton, 1);
        this.addValue(this.inverseSelectionButton, 1);
    }

    public static interface SelectionSettingsPanelListener {
        public void onInverseSelection();

        public void onDeselectAll();

        public void onSelectBlocks();
    }
}

