/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.editor.view;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.Checkbox;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;

public class EditorGridOptionsPanel
extends SimplePanel {
    public static String SHOW_GRID = "Show Grid";
    public static String SHOW_CONNECTORS = "Show Connectors";
    public static String CONNECTOR_SIZE = "Connector Size";
    private Checkbox showGridCheckbox;
    private Checkbox showConnectorCheckbox;
    private Slider connectorSizeSlider;
    private EditorGridOptionsPanelListener listener;

    public EditorGridOptionsPanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.showGridCheckbox = new Checkbox(this.componentFactory, "checkbox");
        this.showGridCheckbox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (EditorGridOptionsPanel.this.getListener() == null) {
                    return;
                }
                EditorGridOptionsPanel.this.getListener().onShowGridChanged(EditorGridOptionsPanel.this.showGridCheckbox.isChecked());
            }
        });
        this.showConnectorCheckbox = new Checkbox(this.componentFactory, "checkbox");
        this.showConnectorCheckbox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (EditorGridOptionsPanel.this.getListener() == null) {
                    return;
                }
                EditorGridOptionsPanel.this.getListener().onShowConnectorsChanged(EditorGridOptionsPanel.this.showConnectorCheckbox.isChecked());
            }
        });
        this.connectorSizeSlider = new Slider(5.0f, 15.0f, 1.0f, false, this.getSkin());
        this.connectorSizeSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (EditorGridOptionsPanel.this.getListener() == null) {
                    return;
                }
                EditorGridOptionsPanel.this.getListener().onSizeSliderChanged(EditorGridOptionsPanel.this.connectorSizeSlider.getValue());
            }
        });
    }

    public EditorGridOptionsPanelListener getListener() {
        return this.listener;
    }

    public void setListener(EditorGridOptionsPanelListener listener) {
        this.listener = listener;
    }

    public void update(boolean showGrid, boolean showConnector, float connectorSize) {
        this.showGridCheckbox.setChecked(showGrid);
        this.showConnectorCheckbox.setChecked(showConnector);
        this.connectorSizeSlider.setValue(connectorSize);
    }

    @Override
    public void construct() {
        super.construct();
        this.addLabel(this.getTranslation("spacecraft_editor_view_grid_show_grid"), 1);
        this.addValueCentered(this.showGridCheckbox, 1);
        this.row();
        this.addLabel(this.getTranslation("spacecraft_editor_view_grid_show_connectors"), 1);
        this.addValueCentered(this.showConnectorCheckbox, 1);
        this.row();
        this.addRow(this.getTranslation("spacecraft_editor_view_grid_connector_size"), this.connectorSizeSlider, 1);
        this.pack();
    }

    public static interface EditorGridOptionsPanelListener {
        public void onShowGridChanged(boolean var1);

        public void onShowConnectorsChanged(boolean var1);

        public void onSizeSliderChanged(float var1);
    }
}

