/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.files;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.files.FileList;

public class FileDialog
extends AbstractForm {
    public static final int MODE_SAVE = 0;
    public static final int MODE_LOAD = 1;
    public static final String EMPTY_SLOT = "Empty Slot";
    public static final String FILE_LOAD = "Load";
    public static final String FILE_SAVE = "Save";
    public static final String FILE_DELETE = "Delete";
    public static final String FILE_BACK = "Back";
    private int cells = 9;
    private int mode;
    private FileList fileList;
    private TextField fileNameValue;

    public FileDialog(ComponentFactory componentFactory, String backgroundStyle) {
        super(componentFactory, "list", backgroundStyle);
        this.pad(15.0f);
        this.fileList = new FileList(componentFactory, "editor-bg");
        this.fileNameValue = new TextField("", componentFactory.getSkin());
        this.fileNameValue.removeListener(this.fileNameValue.getDefaultInputListener());
        this.fileNameValue.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                event.setBubbles(false);
            }
        });
        this.fileNameValue.addListener(this.fileNameValue.getDefaultInputListener());
        this.addValue(this.fileList, 2);
        this.row();
        this.addRow("File name:", this.fileNameValue, 1);
        this.row();
        this.fileList.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (FileDialog.this.fileList.getSelectedFile() != null) {
                    FileDialog.this.fileNameValue.setText(((FileDialog)FileDialog.this).fileList.getSelectedFile().file.getName());
                } else {
                    FileDialog.this.fileNameValue.setText("");
                }
            }
        });
        this.pack();
        this.setMode(1);
    }

    public String getFileName() {
        return this.fileNameValue.getText();
    }

    public FileList getFileList() {
        return this.fileList;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        switch (this.mode) {
            case 1: {
                this.fileNameValue.setDisabled(true);
                break;
            }
            case 0: {
                this.fileNameValue.setDisabled(false);
            }
        }
    }

    public void setFileFilter(String fileFilter) {
        this.fileList.setFileFilter(fileFilter);
    }

    public void setOriginFolder(String folder) {
        this.fileList.setOriginFolder(folder);
    }

    @Override
    public void resetForm() {
        this.fileList.deselectFile();
    }

    @Override
    public void resetValues() {
        this.fileList.deselectFile();
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        if (this.mode == 1) {
            if (this.fileList.getSelectedFile() == null) {
                result.status(Form.ValidationStatus.INVALID).addMessage("Select a file!", null);
            }
        } else if (this.mode == 0 && (this.fileNameValue.getText() == null || this.fileNameValue.getText().isEmpty())) {
            result.status(Form.ValidationStatus.INVALID).addMessage("Invalid file name!", null);
        }
        return result;
    }

    public static interface FileDialogListener {
        public void onFileLoad(AstraXFiles.AstraXFile var1);

        public void onFileSaved(String var1, String var2);

        public void onFileDelete(AstraXFiles.AstraXFile var1);

        public void onBack();
    }
}

