/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.files;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.forms.FormController;
import com.neutronio.astrax.ui.commons.widgets.dialog.DialogBox;
import com.neutronio.astrax.ui.files.FileDialog;

public class FileDialogForm
extends AstraXComponent
implements DialogBox.DialogBoxListener {
    private ComponentFactory factory;
    private FileDialog fileDialog;
    private FormController<FileDialog> formController;
    private FileDialog.FileDialogListener listener;
    private AstraXTextButton submitButton;

    public FileDialogForm(ComponentFactory componentFactory, String backgroundStyle) {
        super(componentFactory, backgroundStyle);
        this.pad(15.0f);
        this.factory = componentFactory;
        this.fileDialog = new FileDialog(componentFactory, null);
        this.formController = new FormController(componentFactory);
        this.formController.setForm(this.fileDialog);
        this.formController.addListener(new DefaultFormListener(){

            @Override
            public void onFormSubmit(AbstractForm form) {
                super.onFormSubmit(form);
                switch (FileDialogForm.this.getMode()) {
                    case 0: {
                        if (FileDialogForm.this.listener == null) break;
                        FileDialogForm.this.listener.onFileSaved(FileDialogForm.this.fileDialog.getFileList().getOriginFolder(), FileDialogForm.this.fileDialog.getFileName());
                        break;
                    }
                    case 1: {
                        if (FileDialogForm.this.listener == null) break;
                        FileDialogForm.this.listener.onFileLoad(FileDialogForm.this.fileDialog.getFileList().getSelectedFile());
                    }
                }
            }

            @Override
            public void onFormCancel(AbstractForm form) {
                super.onFormCancel(form);
                if (FileDialogForm.this.listener != null) {
                    FileDialogForm.this.listener.onBack();
                }
            }

            @Override
            public void onFormAction(AbstractForm form, String action) {
                if (FileDialogForm.this.fileDialog.getFileList().getSelectedFile() == null) {
                    return;
                }
                switch (action) {
                    case "delete": {
                        AstraXApp.astraX.showDialogBox("Are you sure you want to delete '" + ((FileDialogForm)FileDialogForm.this).fileDialog.getFileList().getSelectedFile().file.getName() + "'?", (DialogBox.DialogBoxListener)FileDialogForm.this);
                    }
                }
            }
        });
        this.submitButton = this.formController.addSubmitButton("Load");
        AstraXTextButton cancelButton = this.formController.addBackButton(componentFactory.translate("dialog_cancel"));
        AstraXTextButton deleteButton = this.formController.addCustomButton(componentFactory.translate("form_delete"), "secondary", "delete");
        super.construct();
        this.add(this.fileDialog).colspan(3);
        this.row();
        this.add(cancelButton).padLeft(20.0f).minWidth(120.0f);
        this.add(deleteButton).minWidth(120.0f);
        this.add(this.submitButton).minWidth(120.0f);
        this.pack();
    }

    public int getMode() {
        return this.fileDialog.getMode();
    }

    public void setMode(int mode) {
        this.fileDialog.setMode(mode);
        switch (this.fileDialog.getMode()) {
            case 1: {
                this.submitButton.setText(this.componentFactory.translate("form_load"));
                break;
            }
            case 0: {
                this.submitButton.setText(this.componentFactory.translate("form_save"));
            }
        }
    }

    public void setOriginFolder(String originFolder) {
        this.fileDialog.setOriginFolder(originFolder);
    }

    public void setListener(FileDialog.FileDialogListener listener) {
        this.listener = listener;
    }

    @Override
    public void onProceed() {
        if (this.listener != null) {
            this.listener.onFileDelete(this.fileDialog.getFileList().getSelectedFile());
        }
    }

    @Override
    public void onCancel() {
    }
}

