/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.files;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Pools;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.ReactiveColor;
import com.neutronio.astrax.ui.commons.panels.AbstractPanel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.DefaultPaginator;
import com.neutronio.astrax.ui.commons.widgets.Paginator;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.util.DateFormats;
import com.neutronio.astrax.util.StandardFormats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileList
extends AbstractPanel {
    private ComponentFactory componentFactory;
    private int rows = 7;
    private String fileFilter = "*.json";
    private String originFolder = "";
    private Paginator paginator;
    private FileHandler fileHandler;
    private List<AstraXFiles.AstraXFile> files = new ArrayList<AstraXFiles.AstraXFile>();
    private List<Row> fileRows = new ArrayList<Row>();
    private Row selectedRow;
    private Label originFolderLabel;
    private SimplePanel fileContent;
    private PaginatorComponent paginatorComponent;

    public FileList(ComponentFactory componentFactory, String style) {
        super(componentFactory, style, "tab-inner");
        this.pad(15.0f);
        this.componentFactory = componentFactory;
        this.fileHandler = AstraXApp.astraX.getAstraXFiles();
        this.originFolderLabel = new Label((CharSequence)"", this.panelStyle.labelStyle);
        this.originFolderLabel.setAlignment(8, 8);
        this.fileContent = new SimplePanel(componentFactory, "list", "inset");
        AstraXLabel headerName = this.fileContent.addLabel("File Name", "file-header");
        this.fileContent.getCell(headerName).width((float)this.fileContent.getStyle().minLabelWidth * 2.0f);
        this.fileContent.addLabel("Modified", "file-header");
        this.fileContent.addLabel("Size", "file-header");
        this.fileContent.row();
        for (int i2 = 0; i2 < this.rows; ++i2) {
            Row row = new Row(this.fileContent.addLabel("", "file-large"), this.fileContent.addLabel(""), this.fileContent.addLabel(""));
            this.fileContent.getCell(row.nameLabel).width((int)((float)this.fileContent.getStyle().minLabelWidth * 2.0f)).height(32.0f);
            this.fileContent.row();
            this.fileRows.add(row);
        }
        this.fileContent.pack();
        this.paginator = new DefaultPaginator();
        this.paginatorComponent = new PaginatorComponent(componentFactory);
        this.paginatorComponent.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                FileList.this.updateToContent();
            }
        });
        this.paginatorComponent.setPaginator(this.paginator);
        super.construct();
        this.addValue(this.originFolderLabel, 2);
        this.row();
        this.addValue(this.fileContent, 2);
        this.row();
        this.addValue(this.paginatorComponent, 2);
        this.pack();
    }

    public void setOriginFolder(String folder) {
        this.originFolder = folder;
        this.originFolderLabel.setText(folder);
        try {
            this.files = this.fileHandler.readFilesInDirectory(folder, FileHandler.FileLocation.LOCAL, this.fileFilter);
            this.paginator.configure(this.files.size(), this.rows);
            this.paginatorComponent.setPaginator(this.paginator);
            this.updateToContent();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fileContent.pack();
    }

    private void updateToContent() {
        for (int i2 = 0; i2 < this.fileRows.size(); ++i2) {
            Row row = this.fileRows.get(i2);
            row.file = null;
            row.update("", "", "");
        }
        int startIndex = (this.paginator.getCurrentPage() - 1) * this.rows;
        int buttonIndex = 0;
        for (int i3 = startIndex; i3 < startIndex + this.files.size() && i3 < this.files.size() && buttonIndex < this.fileRows.size(); ++i3) {
            AstraXFiles.AstraXFile file = this.files.get(i3);
            if (!file.file.isFile()) continue;
            Row row = this.fileRows.get(buttonIndex);
            row.file = file;
            Date date = new Date(file.file.lastModified());
            row.update(file.file.getName(), DateFormats.FULL.format(date), StandardFormats.INTEGER.format(file.file.length()) + " bytes");
            ++buttonIndex;
        }
        this.fileContent.pack();
        if (this.selectedRow != null) {
            this.selectedRow.deselect();
        }
        this.pack();
    }

    public String getOriginFolder() {
        return this.originFolder;
    }

    public void setFileFilter(String fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void deselectFile() {
        this.selectedRow.deselect();
        this.selectedRow = null;
        this.componentFactory.playUISound("retract");
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire(changeEvent);
        Pools.free(changeEvent);
    }

    @Override
    public void resetValues() {
    }

    public AstraXFiles.AstraXFile getSelectedFile() {
        return this.selectedRow != null ? this.selectedRow.file : null;
    }

    private class Row {
        AstraXFiles.AstraXFile file;
        boolean isSelected = false;
        AstraXLabel nameLabel;
        AstraXLabel modifiedLabel;
        AstraXLabel fileSizeLabel;
        ClickListener clickListener;

        public Row(AstraXLabel name, AstraXLabel modified, AstraXLabel fileSize) {
            this.nameLabel = name;
            this.modifiedLabel = modified;
            this.fileSizeLabel = fileSize;
            this.clickListener = new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    super.clicked(event, x, y);
                    if (Row.this.file == null) {
                        return;
                    }
                    if (Row.this.isSelected) {
                        FileList.this.deselectFile();
                    } else {
                        FileList.this.componentFactory.playUISound("expand");
                        Row.this.select();
                        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                        FileList.this.fire(changeEvent);
                        Pools.free(changeEvent);
                    }
                }
            };
            this.nameLabel.addListener(this.clickListener);
            this.modifiedLabel.addListener(this.clickListener);
            this.fileSizeLabel.addListener(this.clickListener);
        }

        public void update(String name, String modified, String fileSize) {
            this.nameLabel.setText(name);
            this.modifiedLabel.setText(modified);
            this.fileSizeLabel.setText(fileSize);
        }

        public void select() {
            if (FileList.this.selectedRow != null) {
                FileList.this.selectedRow.deselect();
            }
            this.isSelected = true;
            FileList.this.selectedRow = this;
            this.nameLabel.getBackground().setState(ReactiveColor.ReactiveState.CHECKED);
            this.modifiedLabel.getBackground().setState(ReactiveColor.ReactiveState.CHECKED);
            this.fileSizeLabel.getBackground().setState(ReactiveColor.ReactiveState.CHECKED);
        }

        public void deselect() {
            this.isSelected = false;
            this.nameLabel.getBackground().setState(ReactiveColor.ReactiveState.UP);
            this.modifiedLabel.getBackground().setState(ReactiveColor.ReactiveState.UP);
            this.fileSizeLabel.getBackground().setState(ReactiveColor.ReactiveState.UP);
        }
    }
}

