/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.CompositeButton;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.game.TrackerButton;
import com.neutronio.astrax.ui.game.TrackerButtonListener;
import com.neutronio.astrax.ui.hud.IconPointer;

public class BookmarkTrackerButton
extends CompositeButton
implements TrackerButton {
    private AstraXLabel targetName;
    private AstraXLabel targetDistance;
    private IconPointer icon;
    private TrackerButtonListener listener;
    private CustomAction trackingAction = CustomAction.get(new Runnable(){

        @Override
        public void run() {
            if (BookmarkTrackerButton.this.getListener() != null) {
                BookmarkTrackerButton.this.getListener().onTargetClicked(BookmarkTrackerButton.this.getDiscoveryTarget(), true);
            }
        }
    });
    private DiscoveryTarget discoveryTarget;

    public BookmarkTrackerButton(ComponentFactory componentFactory) {
        this(componentFactory, "transparent");
    }

    public BookmarkTrackerButton(ComponentFactory componentFactory, String backgroundStyle) {
        super(componentFactory, "targetItem", backgroundStyle);
        this.setButtonAction(this.trackingAction);
        this.targetName = this.getHeader("Name");
        this.targetName.setTouchable(Touchable.disabled);
        this.targetName.setAlignment(8, 1);
        this.targetName.setEllipsis(true);
        this.targetDistance = this.getLabel("2000 km");
        this.targetDistance.setTouchable(Touchable.disabled);
        this.icon = new IconPointer(componentFactory.getSkin());
        this.icon.setTouchable(Touchable.disabled);
    }

    @Override
    public void construct() {
        Table table = new Table();
        table.left();
        table.add(this.targetName).maxWidth(140.0f).left().row();
        table.add(this.targetDistance).left();
        this.add(this.icon).pad(10.0f).minSize(24.0f, 24.0f);
        this.add(table).left().width(150.0f).pad(10.0f).expand();
        this.pack();
        this.centerBackground();
    }

    @Override
    public void setDisplay(EntityID id, String name, String distance, String icon) {
        this.targetName.setText(name);
        this.targetDistance.setText(distance);
        this.icon.setIconDrawable(this.componentFactory.getSkin().getDrawable(icon));
    }

    @Override
    public void setDisplay(String icon) {
        this.icon.getStyle().icon = this.componentFactory.getSkin().getDrawable(icon);
        this.icon.setStyle(this.icon.getStyle());
    }

    @Override
    public void setIconColor(Color customColor) {
        this.icon.setIconPointerColor(customColor);
    }

    @Override
    public void setPointerRotation(float angle) {
        this.icon.setDirection(angle);
    }

    @Override
    public void setTrackerButtonListener(TrackerButtonListener listener) {
        this.listener = listener;
    }

    private TrackerButtonListener getListener() {
        return this.listener;
    }

    @Override
    public void setDiscoveryTarget(DiscoveryTarget discoveryTarget) {
        this.discoveryTarget = discoveryTarget;
    }

    @Override
    public DiscoveryTarget getDiscoveryTarget() {
        return this.discoveryTarget;
    }
}

