/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.ProgressBar;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.text.TextPaginator;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.ui.game.TraitIconArray;
import java.util.List;

public class DiscoveryPanel
extends SimplePanel {
    private StaticIcon typeIcon;
    private AstraXLabel nameLabel;
    private AstraXLabel classLabel;
    private AstraXLabel rarityLabel;
    private AstraXLabel descriptionLabel;
    private TextPaginator descriptionTextPaginator;
    private AstraXLabel pointsLabel;
    private ProgressBar discoveredBar;
    private TraitIconArray iconArray;
    private AstraXButton bookmarkButton;
    private DiscoveryTarget discoveryTarget;
    private DiscoveryPanelListener listener;

    public DiscoveryPanel(ComponentFactory componentFactory) {
        super(componentFactory, "discovery", "outset");
        this.iconArray = new TraitIconArray(componentFactory.getSkin());
        this.iconArray.setMaxIconsInRow(6);
        this.typeIcon = new StaticIcon(componentFactory.getSkin(), "clear-32x32");
        this.rarityLabel = this.getLabel("");
        this.classLabel = this.getLabel("");
        this.discoveredBar = new ProgressBar(componentFactory);
        this.descriptionLabel = this.getLabel("");
        this.descriptionLabel.setWrap(true);
        AstraXLabel label = new AstraXLabel(componentFactory, null);
        PaginatorComponent paginatorComponent = new PaginatorComponent(componentFactory);
        label.setAlignment(2, 8);
        label.setWrap(true);
        this.descriptionTextPaginator = new TextPaginator(label, paginatorComponent);
        paginatorComponent.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                DiscoveryPanel.this.descriptionTextPaginator.update();
            }
        });
        Table textTable = new Table();
        textTable.add(label).top().size(300.0f, 300.0f).row();
        textTable.add(paginatorComponent);
        textTable.pack();
        this.pointsLabel = this.getLabel("");
        this.nameLabel = this.getHeader("");
        this.nameLabel.setEllipsis(true);
        this.bookmarkButton = new AstraXButton(componentFactory, "icon_inline_bookmark", "primary");
        this.bookmarkButton.addListener(new Tooltip<AstraXLabel>(new AstraXLabel(componentFactory, "Bookmark this", "tooltip", "transparent")));
        this.bookmarkButton.setCanCheck(false);
        this.bookmarkButton.setDisabled(false);
        this.bookmarkButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (DiscoveryPanel.this.listener != null && DiscoveryPanel.this.discoveryTarget != null) {
                    NavigationBookmark bookmark = new NavigationBookmark(DiscoveryPanel.this.discoveryTarget);
                    DiscoveryPanel.this.bookmarkButton.setDisabled(true);
                    DiscoveryPanel.this.listener.onBookmarkAdded(bookmark);
                }
            }
        }));
        SimplePanel nameGroup = new SimplePanel(componentFactory, "default", "outset");
        nameGroup.pad(5.0f);
        nameGroup.addValue(this.typeIcon).size(32.0f, 32.0f).padLeft(17.0f).padRight(10.0f);
        nameGroup.addValue(this.nameLabel).width(300.0f);
        nameGroup.addValue(this.bookmarkButton).size(32.0f, 32.0f);
        nameGroup.pack();
        this.addValue(nameGroup).colspan(2);
        this.row();
        this.addRow("Class", this.classLabel);
        this.row();
        this.addRow("Rarity", this.rarityLabel);
        this.row();
        this.addRow("Points", this.pointsLabel);
        this.row();
        this.addRow("Discovered", this.discoveredBar);
        this.row();
        this.addValue(this.iconArray, 2).padTop(7.0f).padBottom(7.0f);
        this.row();
        this.addValue(textTable).colspan(2).row();
        this.pack();
    }

    public void setListener(DiscoveryPanelListener listener) {
        this.listener = listener;
    }

    public void updateChildDiscoveries(List<String> icons) {
        this.iconArray.updateWith(icons);
    }

    public void update(DiscoveryTarget discoveryTarget) {
        this.discoveryTarget = discoveryTarget;
        if (discoveryTarget == null || discoveryTarget.discovery == null) {
            this.bookmarkButton.setDisabled(true);
            this.typeIcon.setInlineIcon("icon_inline_questionmark");
            this.classLabel.setText("");
            this.nameLabel.setText("Unknown");
            this.rarityLabel.setText("Unknown");
            this.rarityLabel.setStyle(this.componentFactory.getSkin().get("rarity-" + Discovery.Rarity.COMMON.name().toLowerCase(), Label.LabelStyle.class));
            this.descriptionTextPaginator.setText("An unknown object.");
            this.descriptionTextPaginator.update();
            this.pointsLabel.setText("n.A.");
            this.discoveredBar.setValue(1.0f);
        } else {
            this.bookmarkButton.setDisabled(discoveryTarget.bookmark != null);
            this.typeIcon.setInlineIcon(discoveryTarget.discovery.icon);
            this.classLabel.setText(discoveryTarget.discovery.classification.name());
            this.nameLabel.setText(discoveryTarget.discovery.name);
            this.rarityLabel.setText(discoveryTarget.discovery.rarity.name());
            this.rarityLabel.setStyle(this.componentFactory.getSkin().get("rarity-" + discoveryTarget.discovery.rarity.name().toLowerCase(), Label.LabelStyle.class));
            this.descriptionTextPaginator.setText(discoveryTarget.discovery.description);
            this.descriptionTextPaginator.update();
            this.pointsLabel.setText(discoveryTarget.discovery.discoveryPoints);
            this.discoveredBar.setValue(discoveryTarget.discovery.discoveredFactor);
        }
    }

    public static interface DiscoveryPanelListener {
        public void onBookmarkAdded(NavigationBookmark var1);
    }
}

