/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.neutronio.astrax.app.GeneralSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.Checkbox;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.text.TextSlider;
import com.neutronio.astrax.util.StandardFormats;

public class GameSettingsPanel
extends AbstractForm {
    private TextSlider musicVolumeSlider;
    private TextSlider sfxVolumeSlider;
    private TextSlider uiVolumeSlider;
    private Checkbox showFPSButton;
    private Checkbox showVersionButton;
    private GeneralSettings oldSettings;

    public GameSettingsPanel(ComponentFactory factory, String style, String backgroundStyle) {
        super(factory, style, backgroundStyle);
        this.musicVolumeSlider = new TextSlider(factory);
        this.musicVolumeSlider.setUsePercent(true);
        this.musicVolumeSlider.setFormat(StandardFormats.FLOAT_COUNT);
        this.musicVolumeSlider.align(8);
        this.sfxVolumeSlider = new TextSlider(factory);
        this.sfxVolumeSlider.setUsePercent(true);
        this.sfxVolumeSlider.setFormat(StandardFormats.FLOAT_COUNT);
        this.sfxVolumeSlider.align(8);
        this.uiVolumeSlider = new TextSlider(factory);
        this.uiVolumeSlider.setUsePercent(true);
        this.uiVolumeSlider.setFormat(StandardFormats.FLOAT_COUNT);
        this.uiVolumeSlider.align(8);
        this.showFPSButton = new Checkbox(factory, "checkbox");
        this.showVersionButton = new Checkbox(factory, "checkbox");
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.addRow(this.getTranslation("settings_general_music_volume"), this.musicVolumeSlider, 1);
        this.row();
        this.addRow(this.getTranslation("settings_general_sfx_volume"), this.sfxVolumeSlider, 1);
        this.row();
        this.addRow(this.getTranslation("settings_general_ui_volume"), this.uiVolumeSlider, 1);
        this.row();
        this.addLabel(this.getTranslation("settings_general_show_fps"));
        this.addValueCentered(this.showFPSButton);
        this.row();
        this.addLabel(this.getTranslation("settings_general_show_version"));
        this.addValueCentered(this.showVersionButton);
        this.row();
    }

    @Override
    public ValidationResult validateForm(ValidationResult validationResult) {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        return validationResult;
    }

    @Override
    public void resetForm() {
        this.load(this.oldSettings);
    }

    public void load(GeneralSettings settings) {
        this.oldSettings = settings.copy();
        if (settings != null) {
            this.musicVolumeSlider.setValue(settings.musicVolume);
            this.sfxVolumeSlider.setValue(settings.sfxVolume);
            this.uiVolumeSlider.setValue(settings.uiVolume);
            this.showFPSButton.setChecked(settings.showFPS, false);
            this.showVersionButton.setChecked(settings.showVersion, false);
        } else {
            this.musicVolumeSlider.setValue(0.5f);
            this.sfxVolumeSlider.setValue(0.5f);
            this.uiVolumeSlider.setValue(0.5f);
            this.showFPSButton.setChecked(true, false);
            this.showVersionButton.setChecked(true, false);
        }
    }

    public void applyValuesTo(GeneralSettings settings) {
        if (settings == null) {
            return;
        }
        settings.musicVolume = this.musicVolumeSlider.getValue();
        settings.sfxVolume = this.sfxVolumeSlider.getValue();
        settings.uiVolume = this.uiVolumeSlider.getValue();
        settings.showVersion = this.showVersionButton.isChecked();
        settings.showFPS = this.showFPSButton.isChecked();
    }

    @Override
    public void resetValues() {
        this.load(this.oldSettings);
    }
}

