/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.badlogic.gdx.Input;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.input.DeviceType;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.KeyCatcherComponent;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class InputControlsForm
extends AbstractForm {
    protected Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private static final String INPUTFORM_USAGE_HINT = "Press ESC to abort key assignment.";
    private static final String INPUTFORM_PRESS_KEY = "Press any key";
    protected IconLabel usageHint;
    protected KeyMappingSettings oldSettings;
    protected KeyCatcherComponent currentlySelected;
    protected List<LabelValue> labels = new ArrayList<LabelValue>();
    protected KeyCatcherComponent.KeyCatcherListener keyCatcherListener = new KeyCatcherComponent.KeyCatcherListener(){

        @Override
        public void onStartKeyCatching(KeyCatcherComponent component) {
            InputControlsForm.this.logger.finest("Start keycatching");
            InputControlsForm.this.startKeyCatching(component);
        }

        @Override
        public void onEndKeyCatching(KeyCatcherComponent component, DeviceType deviceType, int keycode) {
            InputControlsForm.this.logger.finest("Stop keycatching: " + (Object)((Object)deviceType) + " | " + keycode + " " + component.getKeyCode());
            if (keycode < 0) {
                component.setKeyName(Input.Keys.toString(component.getKeyCode()), "");
                InputControlsForm.this.stopKeyCatching(component);
                return;
            }
            switch (deviceType) {
                case MOUSE: 
                case GAMEPAD: {
                    component.setKeyName("Button", keycode + "");
                    InputControlsForm.this.logger.finest("Mouse button: " + keycode);
                    break;
                }
                case KEYBOARD: {
                    component.setKeyName("Key", Input.Keys.toString(keycode));
                    InputControlsForm.this.logger.finest("Key button:" + Input.Keys.toString(keycode));
                }
            }
            InputControlsForm.this.stopKeyCatching(component);
        }
    };

    public InputControlsForm(ComponentFactory factory, String style, String backgroundStyle) {
        super(factory, style, backgroundStyle);
        this.usageHint = new IconLabel(this.componentFactory, "info-compact", "info-label");
        this.usageHint.setText(INPUTFORM_USAGE_HINT);
        this.usageHint.construct();
    }

    private void startKeyCatching(KeyCatcherComponent component) {
        if (this.getCurrentlySelected() == null) {
            this.setCurrentlySelected(component);
            this.getStage().setKeyboardFocus(component);
            component.setKeyName(INPUTFORM_PRESS_KEY, "");
        }
    }

    private void stopKeyCatching(KeyCatcherComponent component) {
        this.setCurrentlySelected(null);
        this.getStage().setKeyboardFocus(this.getParent());
    }

    public KeyCatcherComponent getCurrentlySelected() {
        return this.currentlySelected;
    }

    private void setCurrentlySelected(KeyCatcherComponent currentlySelected) {
        this.currentlySelected = currentlySelected;
    }

    public void applyValuesTo(KeyMappingSettings keyMappingSettings) {
        for (LabelValue labelValue : this.labels) {
            if (labelValue.keyCatcherComponent.getKeyCode() <= 0) continue;
            keyMappingSettings.addMapping(labelValue.keyCatcherComponent.getDeviceType(), labelValue.keyCatcherComponent.getInputType(), labelValue.keyCatcherComponent.getKeyCode(), labelValue.keyCatcherComponent.getForAction());
        }
    }

    public void load(KeyMappingSettings keyMappingSettings) {
        this.clear();
        super.construct();
        this.add(this.usageHint).colspan(2).padBottom(20.0f);
        this.row();
        this.oldSettings = keyMappingSettings.copy();
        this.labels.clear();
        for (KeyMappingSettings.KeyMapping mapping : keyMappingSettings.getMappings()) {
            AstraXLabel label = this.getLabel(mapping.actionName);
            KeyCatcherComponent keyCatcherComponent = new KeyCatcherComponent(this.getSkin());
            keyCatcherComponent.setForAction(mapping.actionName);
            keyCatcherComponent.setKeyName(Input.Keys.toString(mapping.code), "");
            keyCatcherComponent.setKeyCode(mapping.code);
            keyCatcherComponent.setDeviceType(mapping.device);
            keyCatcherComponent.setListener(this.keyCatcherListener);
            this.labels.add(new LabelValue(label, keyCatcherComponent));
            this.add(label).fillX();
            this.add(keyCatcherComponent);
            this.row();
        }
        this.pack();
    }

    @Override
    public void resetValues() {
        this.load(this.oldSettings);
    }

    @Override
    public ValidationResult validateForm(ValidationResult validationResult) {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        return validationResult;
    }

    @Override
    public void resetForm() {
        this.load(this.oldSettings);
    }

    @Override
    public void resetStyles() {
    }

    public static class LabelValue {
        public AstraXLabel label;
        public KeyCatcherComponent keyCatcherComponent;

        public LabelValue(AstraXLabel label, KeyCatcherComponent keyCatcherComponent) {
            this.label = label;
            this.keyCatcherComponent = keyCatcherComponent;
        }
    }
}

