/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.BeltTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoveryDatabank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.EllipsoidOrbit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBelt;
import com.neutronio.astrax.gfx.ShapeGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.util.Tree;
import java.util.Objects;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class OrbitRenderer
implements ShapeGraphics {
    private Color selectedColor = null;
    private Color unselectedColor = null;
    private Color beltColor = new Color(0.57254905f, 0.3137255f, 0.0f, 0.5f);
    private EntityID selectedTarget;

    public OrbitRenderer(ComponentFactory componentFactory) {
        this.selectedColor = componentFactory.getSkin().getColor("tertiary");
        this.unselectedColor = componentFactory.getSkin().getColor("primary");
    }

    public void setSelectedTarget(EntityID selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public void renderCallibration(ShapeDrawer shapeDrawer, float x, float y, float parentAlpha) {
        shapeDrawer.setColor(1.0f, 1.0f, 1.0f, parentAlpha);
        shapeDrawer.ellipse(x, y, 4.0f, 4.0f);
        shapeDrawer.ellipse(x, y, 100.0f, 100.0f);
    }

    public void render(ShapeDrawer shapeDrawer, DiscoveryDatabank databank, Tree<Targetable> targetTree, float x, float y, float scale, float parentAlpha) {
        Tree.Node<Targetable> currentNode = targetTree.getRoot();
        this.renderNode(shapeDrawer, databank, currentNode, x, y, scale, parentAlpha);
    }

    private void renderNode(ShapeDrawer shapeDrawer, DiscoveryDatabank databank, Tree.Node<Targetable> node, float x, float y, float scale, float parentAlpha) {
        for (int i2 = 0; i2 < node.size(); ++i2) {
            Tree.Node<Targetable> child = node.getChild(i2);
            this.renderNode(shapeDrawer, databank, child, x, y, scale, parentAlpha);
            Targetable target = child.getObject();
            Tree.Node<Targetable> parentNode = child.getParent();
            if (target.getPositionController() instanceof EllipsoidOrbit && databank.getDiscoveryOf((EntityID)target.getID()).discovery != null) {
                EllipsoidOrbit ellipsoidOrbit = (EllipsoidOrbit)target.getPositionController();
                if (Objects.equals(this.selectedTarget, target.getID())) {
                    shapeDrawer.setDefaultLineWidth(6.0f);
                    shapeDrawer.setColor(this.selectedColor.r, this.selectedColor.g, this.selectedColor.b, parentAlpha);
                } else {
                    shapeDrawer.setDefaultLineWidth(3.0f);
                    shapeDrawer.setColor(this.unselectedColor.r, this.unselectedColor.g, this.unselectedColor.b, parentAlpha);
                }
                shapeDrawer.ellipse(x + (ellipsoidOrbit.getOffsetX() + ((Actor)parentNode.getObject().getGraphics()).getX()) * scale, y + (ellipsoidOrbit.getOffsetY() + ((Actor)parentNode.getObject().getGraphics()).getY()) * scale, ellipsoidOrbit.getWidth() * scale, ellipsoidOrbit.getHeight() * scale);
                continue;
            }
            if (!(target instanceof BeltTarget)) continue;
            BeltTarget beltTarget = (BeltTarget)target;
            float beltWidth = ((OrbitalBelt)beltTarget.getModel()).getSettings().getOrbitMaxRadius() - ((OrbitalBelt)beltTarget.getModel()).getSettings().getOrbitMinRadius();
            float centerRadius = ((OrbitalBelt)beltTarget.getModel()).getSettings().getOrbitMaxRadius() - beltWidth / 2.0f;
            shapeDrawer.setDefaultLineWidth(beltWidth * scale);
            shapeDrawer.setColor(this.beltColor);
            shapeDrawer.arc(x + parentNode.getObject().getWorldPositionX() * scale, y + parentNode.getObject().getWorldPositionY() * scale, centerRadius * scale, 0.0f, (float)Math.PI * 2);
        }
    }
}

