/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.neutronio.astrax.app.SkinSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.widgets.ColorPaletteEditor;
import com.neutronio.astrax.ui.commons.widgets.ColorSwatches;
import com.neutronio.astrax.ui.commons.widgets.RGBSlider;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.util.AstraXUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SkinSettingsForm
extends AbstractForm {
    private static List<Locale> locales = new ArrayList<Locale>();
    private IconLabel saveHint;
    private SelectBox<SelectBoxWrapper<Locale>> languageSelect;
    private AstraXButton editButton;
    private ColorSwatches colorSwatches;
    private ColorPaletteEditor paletteEditor;
    private RGBSlider primaryRGBSlider;
    private RGBSlider secondaryRGBSlider;
    private RGBSlider tertiaryRGBSlider;
    private SkinSettings originalSettings;

    public SkinSettingsForm(ComponentFactory componentFactory, String style, String backgroundStyle) {
        super(componentFactory, style, backgroundStyle);
        this.languageSelect = new SelectBox(componentFactory.getSkin());
        this.saveHint = new IconLabel(componentFactory, "info-compact", "info-label");
        this.saveHint.setText(this.getTranslation("settings_hint_restart"));
        this.saveHint.construct();
        this.editButton = new AstraXButton(componentFactory, "icon_inline_edit", "primary");
        this.editButton.setCanCheck(false);
        this.colorSwatches = new ColorSwatches(componentFactory);
        this.colorSwatches.setIconsPerRow(6);
        this.paletteEditor = new ColorPaletteEditor(componentFactory);
        this.primaryRGBSlider = new RGBSlider(componentFactory);
        this.secondaryRGBSlider = new RGBSlider(componentFactory);
        this.tertiaryRGBSlider = new RGBSlider(componentFactory);
        this.construct();
        this.addValue(this.saveHint, 2);
        this.row();
        this.addRow(this.getTranslation("settings_gui_language"), this.languageSelect);
        this.row();
        this.addHeader2(this.getTranslation("settings_gui_colors"), 2);
        this.row();
        this.addRow(this.getTranslation("settings_gui_primaryColor"), this.primaryRGBSlider);
        this.row();
        this.addRow(this.getTranslation("settings_gui_secondaryColor"), this.secondaryRGBSlider);
        this.row();
        this.addRow(this.getTranslation("settings_gui_tertiaryColor"), this.tertiaryRGBSlider);
        this.pack();
    }

    public void load(SkinSettings settings) {
        this.languageSelect.setItems(new SelectBoxWrapper<Locale>(Locale.ENGLISH.getDisplayName(settings.language), Locale.ENGLISH), new SelectBoxWrapper<Locale>(Locale.GERMAN.getDisplayName(settings.language), Locale.GERMAN));
        this.originalSettings = settings.copy();
        this.paletteEditor.setColorPalette(settings.uiColors);
        this.languageSelect.setSelectedIndex(locales.indexOf(settings.language));
        this.colorSwatches.setColorPalette(settings.uiColors);
        this.primaryRGBSlider.setPickedColor(settings.uiColors.get("primary"));
        this.secondaryRGBSlider.setPickedColor(settings.uiColors.get("secondary"));
        this.tertiaryRGBSlider.setPickedColor(settings.uiColors.get("tertiary"));
    }

    public void applyValuesTo(SkinSettings settings) {
        Color primary = this.primaryRGBSlider.getPickedColor();
        Color secondary = this.secondaryRGBSlider.getPickedColor();
        Color tertiary = this.tertiaryRGBSlider.getPickedColor();
        settings.language = this.languageSelect.getSelected().getPayload();
        settings.uiColors.put("primary", primary.cpy());
        settings.uiColors.put("primary-dark", AstraXUtil.mult(primary.cpy(), 0.7f));
        settings.uiColors.put("primary-bright", AstraXUtil.mult(primary.cpy(), 1.3f));
        settings.uiColors.put("secondary", secondary.cpy());
        settings.uiColors.put("secondary-dark", AstraXUtil.mult(secondary, 0.7f));
        settings.uiColors.put("secondary-bright", AstraXUtil.mult(secondary, 1.3f));
        Color alpha = AstraXUtil.mult(secondary, 1.3f);
        alpha.a = 0.8f;
        settings.uiColors.put("secondary-alpha", alpha);
        settings.uiColors.put("tertiary", tertiary.cpy());
        settings.uiColors.put("tertiary-dark", AstraXUtil.mult(tertiary, 0.7f));
        settings.uiColors.put("tertiary-bright", AstraXUtil.mult(tertiary, 1.3f));
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        return null;
    }

    @Override
    public void resetForm() {
        this.load(this.originalSettings);
    }

    @Override
    public void resetValues() {
    }

    static {
        locales.add(Locale.ENGLISH);
        locales.add(Locale.GERMAN);
    }
}

