/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import java.util.List;

public class TraitIconArray
extends Table {
    private int maxIconsInRow = 6;
    private int iconSize = 48;

    public TraitIconArray(Skin skin) {
        super(skin);
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    public void setMaxIconsInRow(int maxIconsInRow) {
        this.maxIconsInRow = maxIconsInRow;
    }

    public void updateWith(List<String> icons) {
        this.clearChildren();
        if (icons == null || icons.isEmpty()) {
            return;
        }
        int iconCounter = 0;
        for (String icon : icons) {
            Image image = new Image(this.getSkin(), icon);
            this.add(image).size(this.iconSize, this.iconSize).pad(3.0f);
            if (++iconCounter < this.maxIconsInRow) continue;
            this.row();
            iconCounter = 0;
        }
        this.pack();
    }
}

