/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.app.VideoSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.Checkbox;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;

public class VideoSettingsForm
extends AbstractForm {
    private IconLabel videoHint;
    private SelectBox<SelectBoxWrapper> resolutionSelector;
    private Checkbox fullscreenButton;
    private VideoSettings oldSettings;

    public VideoSettingsForm(ComponentFactory componentFactory, String style, String backgroundStyle) {
        super(componentFactory, style, backgroundStyle);
        this.videoHint = new IconLabel(componentFactory, "info-compact", "info-label");
        this.videoHint.setText(this.getTranslation("settings_hint_restart"));
        this.videoHint.construct();
        this.resolutionSelector = new SelectBox(componentFactory.getSkin());
        Array<SelectBoxWrapper<Object>> wrappedResos = new Array<SelectBoxWrapper<Object>>();
        Graphics.DisplayMode[] displayModes = LwjglApplicationConfiguration.getDisplayModes();
        wrappedResos.add(new SelectBoxWrapper<Object>(Gdx.graphics.getWidth() + " x " + Gdx.graphics.getHeight(), null));
        for (Graphics.DisplayMode displayMode : displayModes) {
            if (displayMode.width <= 1200 || displayMode.height <= 800) continue;
            wrappedResos.add(new SelectBoxWrapper<Graphics.DisplayMode>(displayMode.width + " x " + displayMode.height, displayMode));
        }
        this.resolutionSelector.setItems(wrappedResos);
        this.fullscreenButton = new Checkbox(componentFactory, "checkbox");
        super.construct();
        this.addValue(this.videoHint, 2);
        this.row();
        this.addRow(this.getTranslation("settings_video_resolution"), this.resolutionSelector);
        this.row();
        this.addLabel(this.getTranslation("settings_video_fullscreen"));
        this.addValueCentered(this.fullscreenButton);
        this.pack();
    }

    public void load(VideoSettings videoSettings) {
        this.oldSettings = videoSettings.copy();
        this.resolutionSelector.setSelectedIndex(0);
        this.fullscreenButton.setChecked(videoSettings.fullscreen, false);
    }

    public void applyValuesTo(VideoSettings videoSettings) {
        Graphics.DisplayMode displayMode = (Graphics.DisplayMode)this.resolutionSelector.getSelected().getPayload();
        if (displayMode != null) {
            videoSettings.width = displayMode.width;
            videoSettings.height = displayMode.height;
        } else {
            videoSettings.width = 1200;
            videoSettings.height = 800;
        }
        videoSettings.fullscreen = this.fullscreenButton.isChecked();
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        return result;
    }

    @Override
    public void resetForm() {
        this.load(this.oldSettings);
    }

    @Override
    public void resetValues() {
    }
}

