/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.inventory;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.game.inventory.InventoryPanel;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import java.util.ArrayList;

public class CargoSystemPanel
extends SimplePanel
implements TabbedGameMenu.GameMenuTab {
    public static final String INVENTORY_AVAILABLE = "Available Inventories:";
    public static final String INVENTORY_HINT = "Click on an Inventory to see its contents.";
    protected List<SelectBoxWrapper<MultiStackInventory>> inventoryList;
    protected InventoryPanel inventoryPanel;

    public CargoSystemPanel(ComponentFactory componentFactory) {
        super(componentFactory, "gameMenu", "default");
        this.inventoryList = new List(componentFactory.getSkin());
        this.inventoryPanel = new InventoryPanel(componentFactory);
        this.inventoryList.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                CargoSystemPanel.this.updateDisplayedInventory(CargoSystemPanel.this.inventoryList.getSelected().getPayload());
            }
        });
        this.addLabel(INVENTORY_AVAILABLE, 1);
        this.row();
        this.addValue(this.inventoryList, 1);
        this.addValue(this.inventoryPanel, 1);
        this.row();
        this.addLabel(INVENTORY_HINT, 1);
        this.pack();
    }

    public void update(CargoSystem cargoSystem) {
        Array<SelectBoxWrapper<MultiStackInventory>> list = new Array<SelectBoxWrapper<MultiStackInventory>>();
        for (int i2 = 0; i2 < cargoSystem.getInventoryCount(); ++i2) {
            list.add(new SelectBoxWrapper<MultiStackInventory>("[" + (i2 + 1) + "] " + cargoSystem.getInventory(i2).getName(), cargoSystem.getInventory(i2).getInventory()));
        }
        this.inventoryList.setItems(list);
    }

    public void updateDisplayedInventory(MultiStackInventory inventory) {
        this.inventoryPanel.updateWith(inventory);
    }

    @Override
    public java.util.List<Button> getControlButtons() {
        return new ArrayList<Button>();
    }
}

